/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.util.ArrayList;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.cli.AbstractStateCommand;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.state.InfoTypeCompleter;
import org.jboss.galleon.cli.cmd.state.StateInfoUtil;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeaturePackInfo;
import org.jboss.galleon.universe.FeaturePackLocation;

@CommandDefinition(name="info", description="Display information for an installation directory or editing state")
public class StateInfoCommand
extends AbstractStateCommand {
    @Option(completer=InfoTypeCompleter.class)
    private String type;

    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        try {
            FeatureContainer container = this.getFeatureContainer(invoc.getPmSession());
            if (this.type == null) {
                this.displayDependencies(invoc, container, true);
                this.displayConfigs(invoc, container);
            } else {
                switch (this.type) {
                    case "configs": {
                        this.displayConfigs(invoc, container);
                        break;
                    }
                    case "dependencies": {
                        this.displayDependencies(invoc, container, false);
                        break;
                    }
                    case "patches": {
                        this.displayDependencies(invoc, container, true);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.infoFailed(), ex);
        }
    }

    private void displayConfigs(PmCommandInvocation invoc, FeatureContainer container) {
        String str = StateInfoUtil.buildConfigs(container.getFinalConfigs());
        if (str != null) {
            invoc.println(str);
        }
    }

    private void displayDependencies(PmCommandInvocation invoc, FeatureContainer container, boolean includePatches) {
        String str;
        ArrayList<FeaturePackLocation> locs = new ArrayList<FeaturePackLocation>();
        if (container instanceof FeaturePackInfo) {
            StateInfoUtil.printFeaturePack(invoc, container.getFPID().getLocation());
        }
        if (container.getFullDependencies().isEmpty()) {
            for (FeaturePackLocation.FPID g : container.getDependencies()) {
                if (container instanceof FeaturePackInfo && ((FeaturePackInfo)container).getFPID().equals(g)) continue;
                locs.add(invoc.getPmSession().getExposedLocation(g.getLocation()));
            }
        } else {
            for (FeatureContainer c : container.getFullDependencies().values()) {
                locs.add(invoc.getPmSession().getExposedLocation(c.getFPID().getLocation()));
            }
        }
        if ((str = StateInfoUtil.buildDependencies(locs, includePatches ? container.getConfigs() : null)) != null) {
            invoc.println(str);
        }
    }
}

