/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.terminal.Key;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.AbstractDynamicCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.InstalledProducerCompleter;
import org.jboss.galleon.cli.cmd.plugin.AbstractProvisionWithPlugins;
import org.jboss.galleon.cli.cmd.state.StateCheckUpdatesCommand;
import org.jboss.galleon.cli.model.state.State;

public class StateUpgradeCommand
extends AbstractProvisionWithPlugins {
    static final String YES_OPTION_NAME = "yes";

    public StateUpgradeCommand(PmSession pmSession) {
        super(pmSession);
    }

    @Override
    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        ProcessedOption includeAll = ProcessedOptionBuilder.builder().name("include-all-dependencies").hasValue(false).type(Boolean.class).optionType(OptionType.BOOLEAN).description("Include all dependencies.").completer(FileOptionCompleter.class).required(false).build();
        options.add(includeAll);
        ProcessedOption yes = ProcessedOptionBuilder.builder().name(YES_OPTION_NAME).hasValue(false).type(Boolean.class).optionType(OptionType.BOOLEAN).description("No confirmation required.").completer(FileOptionCompleter.class).required(false).shortName('y').build();
        options.add(yes);
        ProcessedOption fp = ProcessedOptionBuilder.builder().name("products").hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("The fp to update").required(false).completer(InstalledProducerCompleter.class).build();
        options.add(fp);
        return options;
    }

    @Override
    protected void doValidateOptions(PmCommandInvocation invoc) throws CommandExecutionException {
    }

    @Override
    protected List<AbstractDynamicCommand.DynamicOption> getDynamicOptions(State state, String id) throws Exception {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRunCommand(PmCommandInvocation session, Map<String, String> options) throws CommandExecutionException {
        block10: {
            try {
                ProvisioningManager mgr = this.getManager(session);
                String fp = this.getFP();
                StateCheckUpdatesCommand.Updates updates = StateCheckUpdatesCommand.getUpdatesTable(mgr, session, this.allDependencies(), this.getFP());
                if (updates.plan.isEmpty()) {
                    session.println("Up to date. No available updates nor patches.");
                    break block10;
                }
                session.println("Some updates and/or patches are available.");
                session.println(updates.t.build());
                if (!this.noConfirm()) {
                    try {
                        Key k = null;
                        while (k == null || !Key.y.equals(k) && !Key.n.equals(k)) {
                            session.print("Proceed with latest updates [y/n]?");
                            KeyAction a = session.input();
                            k = Key.findStartKey(a.buffer().array());
                        }
                        if (Key.n.equals(k)) {
                            return;
                        }
                    }
                    finally {
                        session.println("");
                    }
                }
                mgr.apply(updates.plan, options);
            }
            catch (ProvisioningException ex) {
                throw new CommandExecutionException(session.getPmSession(), CliErrors.upgradeFailed(), ex);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean noConfirm() {
        return this.contains(YES_OPTION_NAME);
    }

    private String getFP() {
        return (String)this.getValue("products");
    }

    private boolean allDependencies() {
        return this.contains("include-all-dependencies");
    }

    @Override
    protected String getName() {
        return "upgrade";
    }

    @Override
    protected String getDescription() {
        return "Upgrade the installation to latest available updates and patches";
    }
}

