/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.universe;

import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.aesh.utils.Config;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.UniverseManager;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.Table;
import org.jboss.galleon.universe.Channel;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Producer;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.universe.UniverseSpec;

@CommandDefinition(name="list", description="List universes and products")
public class UniverseListCommand
extends PmSessionCommand {
    @Option(required=false, name="product", description="Select products that match the provided pattern.")
    private String product;
    @Option(required=false, name="universe", description="References a not installed universe")
    private String universe;

    @Override
    public void runCommand(PmCommandInvocation commandInvocation) throws CommandExecutionException {
        UniverseSpec defaultUniverse = commandInvocation.getPmSession().getUniverse().getDefaultUniverseSpec();
        Pattern cPattern = null;
        if (this.product != null) {
            this.product = this.product.replaceAll("\\*", ".*");
            cPattern = Pattern.compile(this.product);
        }
        if (this.universe != null) {
            int locIndex = this.universe.indexOf("(");
            if (locIndex < 0) {
                throw new CommandExecutionException(CliErrors.invalidUniverse());
            }
            int locIndexEnd = this.universe.indexOf(")");
            if (locIndexEnd < 0) {
                throw new CommandExecutionException(CliErrors.invalidUniverse());
            }
            String factory = this.universe.substring(0, locIndex);
            String location = this.universe.substring(locIndex + 1, locIndexEnd);
            try {
                UniverseSpec spec = new UniverseSpec(factory, location);
                System.out.println("SPEC " + spec);
                UniverseListCommand.printUniverse(cPattern, spec, commandInvocation);
            }
            catch (ProvisioningException ex) {
                throw new CommandExecutionException(commandInvocation.getPmSession(), CliErrors.resolvedUniverseFailed(), ex);
            }
        }
        try {
            UniverseSpec builtinUniverse = commandInvocation.getPmSession().getUniverse().getBuiltinUniverseSpec();
            if (builtinUniverse.equals(defaultUniverse)) {
                commandInvocation.println("Default universe (builtin maven universe)");
                UniverseListCommand.printUniverse(cPattern, builtinUniverse, commandInvocation);
            } else if (defaultUniverse != null) {
                commandInvocation.println("Default universe");
                UniverseListCommand.printUniverse(cPattern, defaultUniverse, commandInvocation);
            }
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(commandInvocation.getPmSession(), CliErrors.resolvedUniverseFailed(), ex);
        }
        Set<String> universes = commandInvocation.getPmSession().getUniverse().getUniverseNames();
        if (!universes.isEmpty()) {
            commandInvocation.println(Config.getLineSeparator() + "Universes local to this provisioning state");
        }
        for (String u : universes) {
            UniverseSpec universe = null;
            try {
                universe = commandInvocation.getPmSession().getUniverse().getUniverseSpec(u);
                if (universe.getFactory().equals("galleon1")) continue;
                UniverseListCommand.printUniverse(cPattern, universe, commandInvocation);
            }
            catch (ProvisioningException ex) {
                throw new CommandExecutionException(commandInvocation.getPmSession(), CliErrors.resolvedUniverseFailed(), ex);
            }
        }
    }

    private static void printUniverse(Pattern cPattern, UniverseSpec spec, PmCommandInvocation invoc) throws ProvisioningException {
        UniverseManager resolver = invoc.getPmSession().getUniverse();
        Universe universe = resolver.getUniverse(spec);
        invoc.println(spec.toString() + (spec.getLocation().equals(universe.getLocation()) ? "" : ", actual location " + universe.getLocation()));
        Collection producers = universe.getProducers();
        if (producers.isEmpty()) {
            invoc.println(" No product available");
        } else {
            UniverseListCommand.printUniverse(cPattern, spec, universe, invoc);
        }
    }

    private static void printUniverse(Pattern cPattern, UniverseSpec spec, Universe<?> universe, PmCommandInvocation invoc) throws ProvisioningException {
        Table table = new Table("Product", "Version", "Qualifier", "Build");
        for (Producer producer : universe.getProducers()) {
            if (cPattern != null && !cPattern.matcher(producer.getName()).matches()) continue;
            for (Channel channel : producer.getChannels()) {
                for (String freq : producer.getFrequencies()) {
                    String build = UniverseListCommand.getBuild(spec, producer, channel, freq);
                    table.addLine(producer.getName(), channel.getName(), freq, build == null ? "" : build);
                }
            }
        }
        if (table.isEmpty()) {
            invoc.println(" No product found.");
        } else {
            table.sort(Table.SortType.ASCENDANT);
            invoc.println(table.build());
        }
    }

    private static String getBuild(UniverseSpec spec, Producer<?> producer, Channel channel, String freq) {
        FeaturePackLocation loc = new FeaturePackLocation(spec, producer.getName(), channel.getName(), freq, null);
        String build = null;
        try {
            build = channel.getLatestBuild(loc);
        }
        catch (ProvisioningException provisioningException) {
            // empty catch block
        }
        return build;
    }
}

