/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.util.StringUtils;

public class ProvisioningConfig
extends FeaturePackDepsConfig {
    private final Builder builder;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProvisioningConfig provisioningConfig) throws ProvisioningDescriptionException {
        return new Builder(provisioningConfig);
    }

    private ProvisioningConfig(Builder builder) throws ProvisioningDescriptionException {
        super(builder);
        this.builder = builder;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append('[');
        if (this.defaultUniverse != null) {
            buf.append("default-universe=").append(this.defaultUniverse);
        }
        if (!this.universeSpecs.isEmpty()) {
            if (this.defaultUniverse != null) {
                buf.append(' ');
            }
            buf.append("universes=[");
            StringUtils.append(buf, this.universeSpecs.entrySet());
            buf.append("] ");
        }
        if (!this.transitiveDeps.isEmpty()) {
            buf.append("transitive=");
            StringUtils.append(buf, this.transitiveDeps.values());
            buf.append(' ');
        }
        StringUtils.append(buf, this.fpDeps.values());
        this.append(buf);
        return buf.append(']').toString();
    }

    public static class Builder
    extends FeaturePackDepsConfigBuilder<Builder> {
        private Builder() {
        }

        private Builder(ProvisioningConfig original) throws ProvisioningDescriptionException {
            if (original != null) {
                for (FeaturePackConfig fp : original.getFeaturePackDeps()) {
                    this.addFeaturePackDep(original.originOf(fp.getLocation().getProducer()), fp);
                }
                if (original.hasTransitiveDeps()) {
                    for (FeaturePackConfig fp : original.getTransitiveDeps()) {
                        this.addFeaturePackDep(original.originOf(fp.getLocation().getProducer()), fp);
                    }
                }
                this.initUniverses(original);
                this.initConfigs(original);
            }
        }

        public ProvisioningConfig build() throws ProvisioningDescriptionException {
            return new ProvisioningConfig(this);
        }
    }
}

