/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Stream;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayoutFactory;
import org.jboss.galleon.layout.FeaturePackLayoutTransformer;
import org.jboss.galleon.layout.FeaturePackPluginVisitor;
import org.jboss.galleon.layout.FeaturePackUpdatePlan;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.layout.ProvisioningPlan;
import org.jboss.galleon.plugin.ProvisioningPlugin;
import org.jboss.galleon.progresstracking.ProgressTracker;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Universe;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;

public class ProvisioningLayout<F extends FeaturePackLayout>
implements AutoCloseable {
    public static final String STAGED = "staged";
    public static final String TMP = "tmp";
    private final ProvisioningLayoutFactory layoutFactory;
    private final FeaturePackLayoutFactory<F> fpFactory;
    private final Handle handle;
    private ProvisioningConfig config;
    private Map<FeaturePackLocation.ProducerSpec, FeaturePackLocation> resolvedVersions;
    private Set<FeaturePackLocation.ProducerSpec> transitiveDeps;
    private Map<FeaturePackLocation.ProducerSpec, Set<FeaturePackLocation.FPID>> conflicts = Collections.emptyMap();
    private Map<FeaturePackLocation.ProducerSpec, F> featurePacks = new HashMap<FeaturePackLocation.ProducerSpec, F>();
    private List<F> ordered = new ArrayList<F>();
    private Map<FeaturePackLocation.FPID, F> allPatches = Collections.emptyMap();
    private Map<FeaturePackLocation.FPID, List<F>> fpPatches = Collections.emptyMap();
    private ProgressTracker<FeaturePackLocation.ProducerSpec> updatesTracker;
    private ProgressTracker<FeaturePackLocation.FPID> buildTracker;

    ProvisioningLayout(ProvisioningLayoutFactory layoutFactory, ProvisioningConfig config, FeaturePackLayoutFactory<F> fpFactory, boolean cleanupTransitive) throws ProvisioningException {
        this.layoutFactory = layoutFactory;
        this.fpFactory = fpFactory;
        this.config = config;
        this.handle = layoutFactory.createHandle();
        this.build(cleanupTransitive, true);
    }

    <O extends FeaturePackLayout> ProvisioningLayout(ProvisioningLayout<O> other, final FeaturePackLayoutFactory<F> fpFactory) throws ProvisioningException {
        this(other, fpFactory, new FeaturePackLayoutTransformer<F, O>(){

            @Override
            public F transform(O other) throws ProvisioningException {
                return fpFactory.newFeaturePack(other.getFPID().getLocation(), other.getSpec(), other.getDir(), other.getType());
            }
        });
    }

    <O extends FeaturePackLayout> ProvisioningLayout(ProvisioningLayout<O> other, final FeaturePackLayoutTransformer<F, O> transformer) throws ProvisioningException {
        this(other, new FeaturePackLayoutFactory<F>(){
            final FeaturePackLayoutFactory<O> fpFactory;
            {
                this.fpFactory = ProvisioningLayout.this.fpFactory;
            }

            @Override
            public F newFeaturePack(FeaturePackLocation fpl, FeaturePackSpec spec, Path dir, int type) throws ProvisioningException {
                return transformer.transform(this.fpFactory.newFeaturePack(fpl, spec, dir, type));
            }
        }, transformer);
    }

    private <O extends FeaturePackLayout> ProvisioningLayout(ProvisioningLayout<O> other, FeaturePackLayoutFactory<F> fpFactory, FeaturePackLayoutTransformer<F, O> transformer) throws ProvisioningException {
        this.layoutFactory = other.layoutFactory;
        this.fpFactory = fpFactory;
        this.config = other.config;
        for (FeaturePackLayout featurePackLayout : other.ordered) {
            F fp = transformer.transform(featurePackLayout);
            this.featurePacks.put(fp.getFPID().getProducer(), fp);
            this.ordered.add(fp);
        }
        if (!other.fpPatches.isEmpty()) {
            this.fpPatches = new HashMap<FeaturePackLocation.FPID, List<F>>(other.fpPatches.size());
            for (Map.Entry entry : other.fpPatches.entrySet()) {
                List patches = (List)entry.getValue();
                ArrayList<F> convertedPatches = new ArrayList<F>(patches.size());
                for (FeaturePackLayout o : patches) {
                    convertedPatches.add(transformer.transform(o));
                }
                this.fpPatches.put((FeaturePackLocation.FPID)entry.getKey(), (List<F>)convertedPatches);
            }
        }
        this.handle = other.handle;
        this.handle.incrementRefs();
    }

    public ProvisioningLayoutFactory getFactory() {
        return this.layoutFactory;
    }

    public FeaturePackLayoutFactory<F> getFeaturePackFactory() {
        return this.fpFactory;
    }

    public <O extends FeaturePackLayout> ProvisioningLayout<O> transform(FeaturePackLayoutFactory<O> fpFactory) throws ProvisioningException {
        return new ProvisioningLayout<O>(this, fpFactory);
    }

    public <O extends FeaturePackLayout> ProvisioningLayout<O> transform(FeaturePackLayoutTransformer<O, F> transformer) throws ProvisioningException {
        return new ProvisioningLayout<O>(this, transformer);
    }

    public void apply(ProvisioningPlan plan) throws ProvisioningException {
        if (plan.isEmpty()) {
            return;
        }
        ProvisioningConfig.Builder configBuilder = ProvisioningConfig.builder(this.config);
        if (plan.hasUpdates()) {
            FeaturePackConfig.Builder fpBuilder;
            FeaturePackUpdatePlan fpPlan;
            FeaturePackLocation.ProducerSpec producer;
            Map<FeaturePackLocation.ProducerSpec, FeaturePackUpdatePlan> updates = plan.getUpdateMap();
            HashSet<FeaturePackLocation.ProducerSpec> processed = new HashSet<FeaturePackLocation.ProducerSpec>(updates.size());
            for (FeaturePackConfig featurePackConfig : this.config.getFeaturePackDeps()) {
                producer = featurePackConfig.getLocation().getProducer();
                fpPlan = updates.get(producer);
                if (fpPlan == null || fpPlan.isEmpty()) continue;
                if (!fpPlan.getInstalledLocation().equals(featurePackConfig.getLocation())) {
                    throw new ProvisioningException("Location in the update plan " + fpPlan.getInstalledLocation() + " does not match the installed location " + featurePackConfig.getLocation());
                }
                fpBuilder = FeaturePackConfig.builder(fpPlan.getNewLocation()).init(featurePackConfig);
                if (fpPlan.hasNewPatches()) {
                    for (FeaturePackLocation.FPID patchId : fpPlan.getNewPatches()) {
                        fpBuilder.addPatch(patchId);
                    }
                }
                configBuilder.updateFeaturePackDep(fpBuilder.build());
                processed.add(producer);
            }
            for (FeaturePackConfig featurePackConfig : this.config.getTransitiveDeps()) {
                producer = featurePackConfig.getLocation().getProducer();
                fpPlan = updates.get(producer);
                if (fpPlan == null || fpPlan.isEmpty()) continue;
                if (featurePackConfig.getLocation().getBuild() != null && !fpPlan.getInstalledLocation().equals(featurePackConfig.getLocation())) {
                    throw new ProvisioningException("Update plan build " + fpPlan.getInstalledLocation() + " does not match the installed build " + featurePackConfig.getLocation());
                }
                fpBuilder = FeaturePackConfig.transitiveBuilder(fpPlan.getNewLocation()).init(featurePackConfig);
                if (fpPlan.hasNewPatches()) {
                    for (FeaturePackLocation.FPID patchId : fpPlan.getNewPatches()) {
                        fpBuilder.addPatch(patchId);
                    }
                }
                configBuilder.updateFeaturePackDep(fpBuilder.build());
                processed.add(producer);
            }
            if (processed.size() < updates.size()) {
                for (Map.Entry entry : updates.entrySet()) {
                    if (processed.contains(entry.getKey())) continue;
                    FeaturePackUpdatePlan update = (FeaturePackUpdatePlan)entry.getValue();
                    FeaturePackConfig.Builder fpBuilder2 = FeaturePackConfig.transitiveBuilder(update.getNewLocation());
                    if (update.hasNewPatches()) {
                        for (FeaturePackLocation.FPID patchId : update.getNewPatches()) {
                            fpBuilder2.addPatch(patchId);
                        }
                    }
                    configBuilder.addFeaturePackDep(fpBuilder2.build());
                }
            }
        }
        if (plan.hasInstall()) {
            for (FeaturePackConfig fpConfig : plan.getInstall()) {
                this.install(fpConfig, configBuilder);
            }
        }
        if (plan.hasUninstall()) {
            for (FeaturePackLocation.ProducerSpec producer : plan.getUninstall()) {
                this.uninstall(producer.getLocation().getFPID(), configBuilder);
            }
        }
        this.rebuild(configBuilder.build(), true);
    }

    public void install(FeaturePackLocation fpl) throws ProvisioningException {
        this.install(FeaturePackConfig.forLocation(fpl));
    }

    public void install(FeaturePackConfig fpConfig) throws ProvisioningException {
        this.rebuild(this.install(fpConfig, ProvisioningConfig.builder(this.config)).build(), false);
    }

    private ProvisioningConfig.Builder install(FeaturePackConfig fpConfig, ProvisioningConfig.Builder configBuilder) throws ProvisioningException {
        FeaturePackSpec fpSpec;
        FeaturePackLocation fpl = fpConfig.getLocation();
        FeaturePackLocation.FPID fpid = fpl.getFPID();
        if (this.allPatches.containsKey(fpid)) {
            throw new ProvisioningException(Errors.patchAlreadyApplied(fpid));
        }
        if (!fpl.hasBuild()) {
            fpl = this.layoutFactory.getUniverseResolver().resolveLatestBuild(fpl);
        }
        if ((fpSpec = this.layoutFactory.resolveFeaturePack(fpl, 0, this.fpFactory).getSpec()).isPatch()) {
            FeaturePackLayout patchTarget = (FeaturePackLayout)this.featurePacks.get(fpSpec.getPatchFor().getProducer());
            if (patchTarget == null || !patchTarget.getFPID().equals(fpSpec.getPatchFor())) {
                throw new ProvisioningException(Errors.patchNotApplicable(fpid, fpSpec.getPatchFor()));
            }
            FeaturePackConfig installedFpConfig = this.config.getFeaturePackDep(fpSpec.getPatchFor().getProducer());
            if (installedFpConfig == null) {
                installedFpConfig = this.config.getTransitiveDep(fpSpec.getPatchFor().getProducer());
            }
            if (installedFpConfig == null) {
                return (ProvisioningConfig.Builder)configBuilder.addFeaturePackDep(FeaturePackConfig.transitiveBuilder(patchTarget.getFPID().getLocation()).addPatch(fpid).build());
            }
            return (ProvisioningConfig.Builder)configBuilder.updateFeaturePackDep(FeaturePackConfig.builder(installedFpConfig.getLocation()).init(installedFpConfig).addPatch(fpid).build());
        }
        FeaturePackLayout installedFp = (FeaturePackLayout)this.featurePacks.get(fpid.getProducer());
        if (installedFp != null) {
            if (installedFp.isTransitiveDep() == fpConfig.isTransitive()) {
                return (ProvisioningConfig.Builder)configBuilder.updateFeaturePackDep(fpConfig);
            }
            if (installedFp.isTransitiveDep()) {
                if (this.config.hasTransitiveDep(fpid.getProducer())) {
                    configBuilder.removeTransitiveDep(fpid);
                }
                return (ProvisioningConfig.Builder)configBuilder.addFeaturePackDep(this.getIndexForDepToInstall(configBuilder, fpid.getProducer()), fpConfig);
            }
            configBuilder.removeFeaturePackDep(fpid.getLocation());
        }
        return (ProvisioningConfig.Builder)configBuilder.addFeaturePackDep(fpConfig);
    }

    private int getIndexForDepToInstall(ProvisioningConfig.Builder configBuilder, FeaturePackLocation.ProducerSpec producer) throws ProvisioningException {
        int index = Integer.MAX_VALUE;
        HashSet<FeaturePackLocation.ProducerSpec> visitedFps = new HashSet<FeaturePackLocation.ProducerSpec>(this.featurePacks.size());
        visitedFps.add(producer);
        for (FeaturePackLayout f : this.featurePacks.values()) {
            if (f.isTransitiveDep() || !this.dependsOn(f, producer, visitedFps)) continue;
            index = Math.min(index, configBuilder.getFeaturePackDepIndex(f.getFPID().getLocation()));
        }
        return index;
    }

    private boolean dependsOn(F f, FeaturePackLocation.ProducerSpec dep, Set<FeaturePackLocation.ProducerSpec> visitedFps) {
        FeaturePackSpec spec = f.getSpec();
        if (!spec.hasFeaturePackDeps()) {
            return false;
        }
        if (spec.hasFeaturePackDep(dep) || spec.hasTransitiveDep(dep)) {
            return true;
        }
        for (FeaturePackConfig fpConfig : spec.getFeaturePackDeps()) {
            FeaturePackLocation.ProducerSpec producer = fpConfig.getLocation().getProducer();
            if (!visitedFps.add(producer)) continue;
            if (this.dependsOn((FeaturePackLayout)this.featurePacks.get(producer), dep, visitedFps)) {
                return true;
            }
            visitedFps.remove(producer);
        }
        return false;
    }

    public void uninstall(FeaturePackLocation.FPID fpid) throws ProvisioningException {
        this.rebuild(this.uninstall(fpid, ProvisioningConfig.builder(this.config)).build(), true);
    }

    private ProvisioningConfig.Builder uninstall(FeaturePackLocation.FPID fpid, ProvisioningConfig.Builder configBuilder) throws ProvisioningException {
        if (this.allPatches.containsKey(fpid)) {
            FeaturePackLayout patchFp = (FeaturePackLayout)this.allPatches.get(fpid);
            FeaturePackLocation.ProducerSpec patchTarget = patchFp.getSpec().getPatchFor().getProducer();
            FeaturePackConfig targetConfig = this.config.getFeaturePackDep(patchTarget);
            if (targetConfig == null && (targetConfig = this.config.getTransitiveDep(patchTarget)) == null) {
                throw new ProvisioningException("Target feature-pack for patch " + fpid + " could not be found");
            }
            this.layoutFactory.removeFeaturePackDir(patchTarget.getLocation());
            return (ProvisioningConfig.Builder)configBuilder.updateFeaturePackDep(FeaturePackConfig.builder(targetConfig).removePatch(fpid).build());
        }
        FeaturePackLayout installedFp = (FeaturePackLayout)this.featurePacks.get(fpid.getProducer());
        if (installedFp == null) {
            throw new ProvisioningException(Errors.unknownFeaturePack(fpid));
        }
        if (fpid.getBuild() != null && !installedFp.getFPID().getBuild().equals(fpid.getBuild())) {
            throw new ProvisioningException(Errors.unknownFeaturePack(fpid));
        }
        FeaturePackConfig fpConfig = this.config.getFeaturePackDep(fpid.getProducer());
        if (fpConfig == null) {
            throw new ProvisioningException(Errors.unsatisfiedFeaturePackDep(fpid.getProducer()));
        }
        configBuilder.removeFeaturePackDep(fpid.getLocation());
        if (!configBuilder.hasFeaturePackDeps()) {
            configBuilder.clearFeaturePackDeps();
        }
        return configBuilder;
    }

    public ProvisioningPlan getUpdates(boolean includeTransitive) throws ProvisioningException {
        return this.getUpdatesInternal(includeTransitive ? this.featurePacks.keySet() : this.config.getProducers());
    }

    public ProvisioningPlan getUpdates(FeaturePackLocation.ProducerSpec ... producers) throws ProvisioningException {
        if (producers.length == 0) {
            return this.getUpdates(false);
        }
        return this.getUpdatesInternal(Arrays.asList(producers));
    }

    private ProvisioningPlan getUpdatesInternal(Collection<FeaturePackLocation.ProducerSpec> producers) throws ProvisioningException {
        ProvisioningPlan plan = ProvisioningPlan.builder();
        this.updatesTracker = this.getUpdatesTracker();
        this.updatesTracker.starting(producers.size());
        for (FeaturePackLocation.ProducerSpec producer : producers) {
            this.updatesTracker.processing(producer);
            FeaturePackUpdatePlan fpPlan = this.getFeaturePackUpdate(producer);
            if (!fpPlan.isEmpty()) {
                plan.update(fpPlan);
            }
            this.updatesTracker.processed(producer);
        }
        this.updatesTracker.complete();
        return plan;
    }

    public FeaturePackUpdatePlan getFeaturePackUpdate(FeaturePackLocation.ProducerSpec producer) throws ProvisioningException {
        Set<FeaturePackLocation.FPID> patchIds;
        FeaturePackLayout f = (FeaturePackLayout)this.featurePacks.get(producer);
        if (f == null) {
            throw new ProvisioningException(Errors.unknownFeaturePack(producer.getLocation().getFPID()));
        }
        FeaturePackLocation fpl = f.getFPID().getLocation();
        Universe<?> universe = this.layoutFactory.getUniverseResolver().getUniverse(fpl.getUniverse());
        Object channel = universe.getProducer(fpl.getProducerName()).getChannel(fpl.getChannelName());
        List<F> patches = this.fpPatches.get(fpl.getFPID());
        if (patches == null || patches.isEmpty()) {
            patchIds = Collections.emptySet();
        } else if (patches.size() == 1) {
            patchIds = Collections.singleton(((FeaturePackLayout)patches.get(0)).getFPID());
        } else {
            HashSet<FeaturePackLocation.FPID> tmp = new HashSet<FeaturePackLocation.FPID>(patches.size());
            for (FeaturePackLayout p : patches) {
                tmp.add(p.getFPID());
            }
            patchIds = CollectionUtils.unmodifiable(tmp);
        }
        return channel.getUpdatePlan(FeaturePackUpdatePlan.request(fpl, patchIds, f.isTransitiveDep()));
    }

    public ProvisioningConfig getConfig() {
        return this.config;
    }

    public boolean hasFeaturePacks() {
        return !this.featurePacks.isEmpty();
    }

    public boolean hasFeaturePack(FeaturePackLocation.ProducerSpec producer) {
        return this.featurePacks.containsKey(producer);
    }

    public F getFeaturePack(FeaturePackLocation.ProducerSpec producer) throws ProvisioningException {
        FeaturePackLayout p = (FeaturePackLayout)this.featurePacks.get(producer);
        if (p == null) {
            throw new ProvisioningException(Errors.unknownFeaturePack(producer.getLocation().getFPID()));
        }
        return (F)p;
    }

    public List<F> getOrderedFeaturePacks() {
        return this.ordered;
    }

    public List<F> getPatches(FeaturePackLocation.FPID fpid) {
        List<F> patches = this.fpPatches.get(fpid);
        return patches == null ? Collections.emptyList() : patches;
    }

    public boolean hasPlugins() {
        return this.handle.pluginsDir != null;
    }

    public Path getPluginsDir() {
        return this.handle.pluginsDir;
    }

    public boolean hasResources() {
        return this.handle.resourcesDir != null;
    }

    public Path getResources() {
        return this.handle.resourcesDir;
    }

    public Path getResource(String ... path) throws ProvisioningException {
        return this.handle.getResource(path);
    }

    public Path getTmpPath(String ... path) {
        return this.handle.getTmpPath(path);
    }

    public ClassLoader getPluginsClassLoader() throws ProvisioningException {
        return this.handle.getPluginsClassLoader();
    }

    public <T extends ProvisioningPlugin> void visitPlugins(FeaturePackPluginVisitor<T> visitor, Class<T> clazz) throws ProvisioningException {
        this.handle.visitPlugins(visitor, clazz);
    }

    public Path newStagedDir() throws ProvisioningException {
        return this.handle.newStagedDir();
    }

    private void rebuild(ProvisioningConfig config, boolean cleanupTransitive) throws ProvisioningException {
        boolean trackProgress = this.featurePacks.isEmpty();
        this.featurePacks.clear();
        this.ordered.clear();
        this.allPatches = Collections.emptyMap();
        this.fpPatches = Collections.emptyMap();
        this.config = config;
        this.handle.cleanup();
        this.build(cleanupTransitive, trackProgress);
    }

    private void build(boolean cleanupTransitive, boolean trackProgress) throws ProvisioningException {
        try {
            this.doBuild(cleanupTransitive, trackProgress);
        }
        catch (Error | RuntimeException | ProvisioningException e) {
            this.handle.close();
            throw e;
        }
    }

    private void doBuild(boolean cleanupTransitive, boolean trackProgress) throws ProvisioningException {
        this.buildTracker = this.getBuildTracker(trackProgress);
        this.buildTracker.starting(-1L);
        HashMap<FeaturePackLocation.ProducerSpec, FeaturePackLocation.FPID> depBranch = new HashMap<FeaturePackLocation.ProducerSpec, FeaturePackLocation.FPID>();
        this.layout(this.config, depBranch, 0);
        if (!this.conflicts.isEmpty()) {
            throw new ProvisioningDescriptionException(Errors.fpVersionCheckFailed(this.conflicts.values()));
        }
        if (this.transitiveDeps != null) {
            ProvisioningConfig.Builder newConfig = null;
            Object notUsedTransitive = Collections.emptyList();
            for (FeaturePackLocation.ProducerSpec producer : this.transitiveDeps) {
                if (this.featurePacks.containsKey(producer)) continue;
                if (cleanupTransitive && this.config.hasTransitiveDep(producer)) {
                    if (newConfig == null) {
                        newConfig = ProvisioningConfig.builder(this.config);
                    }
                    newConfig.removeTransitiveDep(producer.getLocation().getFPID());
                    continue;
                }
                notUsedTransitive = CollectionUtils.add(notUsedTransitive, producer);
            }
            if (!notUsedTransitive.isEmpty()) {
                throw new ProvisioningDescriptionException(Errors.transitiveDependencyNotFound(notUsedTransitive.toArray(new FeaturePackLocation.ProducerSpec[notUsedTransitive.size()])));
            }
            if (newConfig != null) {
                this.config = newConfig.build();
            }
            this.transitiveDeps = null;
        }
        if (this.resolvedVersions != null) {
            ProvisioningConfig.Builder builder = ProvisioningConfig.builder(this.config);
            for (FeaturePackConfig fpConfig : this.config.getFeaturePackDeps()) {
                FeaturePackLocation.ProducerSpec producer;
                producer = fpConfig.getLocation().getProducer();
                FeaturePackLocation resolvedFpl = this.resolvedVersions.remove(producer);
                if (resolvedFpl == null) continue;
                builder.updateFeaturePackDep(this.config.originOf(producer), FeaturePackConfig.builder(resolvedFpl).init(fpConfig).build());
            }
            if (!this.resolvedVersions.isEmpty()) {
                for (FeaturePackLocation fpl : this.resolvedVersions.values()) {
                    builder.addTransitiveDep(fpl);
                }
            }
            this.config = builder.build();
            this.resolvedVersions = null;
        }
        if (!this.fpPatches.isEmpty()) {
            boolean rewriteResources = false;
            boolean rewritePlugins = false;
            for (FeaturePackLayout f : this.ordered) {
                List<F> patches = this.fpPatches.get(f.getFPID());
                if (patches == null) {
                    Path fpPlugins;
                    Path fpResources;
                    if (rewriteResources && Files.exists(fpResources = f.getDir().resolve("resources"), new LinkOption[0])) {
                        this.patchDir(this.getResources(), fpResources);
                    }
                    if (!rewritePlugins || !Files.exists(fpPlugins = f.getDir().resolve("plugins"), new LinkOption[0])) continue;
                    this.patchDir(this.getPluginsDir(), fpPlugins);
                    continue;
                }
                Path fpDir = f.getDir();
                for (FeaturePackLayout patch : patches) {
                    Path patchDir = patch.getDir();
                    Path patchContent = patchDir.resolve("packages");
                    if (Files.exists(patchContent, new LinkOption[0])) {
                        this.patchDir(fpDir.resolve("packages"), patchContent);
                    }
                    if (Files.exists(patchContent = patchDir.resolve("features"), new LinkOption[0])) {
                        this.patchDir(fpDir.resolve("features"), patchContent);
                    }
                    if (Files.exists(patchContent = patchDir.resolve("feature_groups"), new LinkOption[0])) {
                        this.patchDir(fpDir.resolve("feature_groups"), patchContent);
                    }
                    if (Files.exists(patchContent = patchDir.resolve("plugins"), new LinkOption[0])) {
                        rewritePlugins = true;
                        this.patchDir(this.getPluginsDir(), patchContent);
                    }
                    if (!Files.exists(patchContent = patchDir.resolve("resources"), new LinkOption[0])) continue;
                    rewriteResources = true;
                    this.patchDir(fpDir.resolve("resources"), patchContent);
                    this.patchDir(this.getResources(), patchContent);
                }
            }
        }
        this.buildTracker.complete();
    }

    private void patchDir(Path fpDir, Path patchDir) throws ProvisioningException {
        try {
            IoUtils.copy(patchDir, fpDir);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.copyFile(patchDir, fpDir));
        }
    }

    private void layout(FeaturePackDepsConfig config, Map<FeaturePackLocation.ProducerSpec, FeaturePackLocation.FPID> branch, int type) throws ProvisioningException {
        if (!config.hasFeaturePackDeps()) {
            return;
        }
        List<Object> added = Collections.emptyList();
        if (config.hasTransitiveDeps()) {
            if (this.transitiveDeps == null) {
                this.transitiveDeps = new HashSet<FeaturePackLocation.ProducerSpec>();
            }
            for (FeaturePackConfig transitiveConfig : config.getTransitiveDeps()) {
                FeaturePackLocation fpl = transitiveConfig.getLocation();
                this.transitiveDeps.add(fpl.getProducer());
                if (transitiveConfig.hasPatches()) {
                    this.addPatches(transitiveConfig);
                }
                if (branch.containsKey(fpl.getProducer()) || fpl.getBuild() == null) continue;
                branch.put(fpl.getProducer(), fpl.getFPID());
                added = CollectionUtils.add(added, fpl.getProducer());
            }
        }
        Collection<FeaturePackConfig> fpDeps = config.getFeaturePackDeps();
        ArrayList<FeaturePackLayout> queue = new ArrayList<FeaturePackLayout>(fpDeps.size());
        for (FeaturePackConfig fpConfig : fpDeps) {
            FeaturePackLayout fp;
            FeaturePackLocation.FPID branchId;
            FeaturePackLocation fpl = fpConfig.getLocation();
            if (fpConfig.hasPatches()) {
                this.addPatches(fpConfig);
            }
            if ((branchId = branch.get(fpl.getProducer())) == null) {
                if (fpl.getBuild() == null) {
                    fpl = this.layoutFactory.getUniverseResolver().resolveLatestBuild(fpl);
                    if (this.resolvedVersions == null) {
                        this.resolvedVersions = new LinkedHashMap<FeaturePackLocation.ProducerSpec, FeaturePackLocation>();
                    }
                    this.resolvedVersions.put(fpl.getProducer(), fpl);
                }
            } else if (!branchId.getBuild().equals(fpl.getBuild())) {
                fpl = fpl.replaceBuild(branchId.getBuild());
            }
            if ((fp = (FeaturePackLayout)this.featurePacks.get(fpl.getProducer())) != null) {
                if (branchId != null || fpl.getBuild().equals(fp.getFPID().getBuild())) continue;
                Set<FeaturePackLocation.FPID> versions = this.conflicts.get(fp.getFPID().getProducer());
                if (versions != null) {
                    versions.add(fpl.getFPID());
                    continue;
                }
                versions = new LinkedHashSet<FeaturePackLocation.FPID>();
                versions.add(fp.getFPID());
                versions.add(fpl.getFPID());
                this.conflicts = CollectionUtils.putLinked(this.conflicts, fpl.getProducer(), versions);
                continue;
            }
            this.buildTracker.processing(fpl.getFPID());
            fp = this.layoutFactory.resolveFeaturePack(fpl, type, this.fpFactory);
            this.buildTracker.processed(fpl.getFPID());
            this.featurePacks.put(fpl.getProducer(), fp);
            queue.add(fp);
            if (branchId != null) continue;
            branch.put(fpl.getProducer(), fpl.getFPID());
            added = CollectionUtils.add(added, fpl.getProducer());
        }
        if (!queue.isEmpty()) {
            for (FeaturePackLayout p : queue) {
                this.layout(p.getSpec(), branch, 1);
                this.handle.copyResources(p.getDir());
                this.ordered.add(p);
            }
        }
        if (!added.isEmpty()) {
            for (FeaturePackLocation.ProducerSpec producer : added) {
                branch.remove(producer);
            }
        }
    }

    private void addPatches(FeaturePackConfig fpConfig) throws ProvisioningException {
        for (FeaturePackLocation.FPID patchId : fpConfig.getPatches()) {
            if (this.allPatches.containsKey(patchId)) continue;
            this.loadPatch(patchId);
        }
    }

    private void loadPatch(FeaturePackLocation.FPID patchId) throws ProvisioningException {
        FeaturePackLocation.FPID patchFor;
        List<F> patchList;
        F patchFp = this.layoutFactory.resolveFeaturePack(patchId.getLocation(), 2, this.fpFactory);
        FeaturePackSpec spec = patchFp.getSpec();
        if (!spec.isPatch()) {
            throw new ProvisioningDescriptionException(patchId + " is not a patch but listed as one");
        }
        this.allPatches = CollectionUtils.put(this.allPatches, patchId, patchFp);
        if (spec.hasFeaturePackDeps()) {
            for (FeaturePackConfig patchDep : spec.getFeaturePackDeps()) {
                FeaturePackLocation.FPID patchDepId = patchDep.getLocation().getFPID();
                if (this.allPatches.containsKey(patchDepId)) continue;
                this.loadPatch(patchDepId);
            }
        }
        if ((patchList = this.fpPatches.get(patchFor = spec.getPatchFor())) == null) {
            this.fpPatches = CollectionUtils.put(this.fpPatches, patchFor, Collections.singletonList(patchFp));
        } else if (patchList.size() == 1) {
            ArrayList<F> tmp = new ArrayList<F>(2);
            tmp.add(patchList.get(0));
            tmp.add(patchFp);
            this.fpPatches = CollectionUtils.put(this.fpPatches, patchFor, tmp);
        } else {
            patchList.add(patchFp);
        }
    }

    private ProgressTracker<FeaturePackLocation.ProducerSpec> getUpdatesTracker() {
        return this.updatesTracker == null ? (this.updatesTracker = this.layoutFactory.getProgressTracker("UPDATES")) : this.updatesTracker;
    }

    private ProgressTracker<FeaturePackLocation.FPID> getBuildTracker(boolean trackProgress) {
        if (!trackProgress) {
            return ProvisioningLayoutFactory.getNoOpProgressTracker();
        }
        return this.buildTracker == null ? (this.buildTracker = this.layoutFactory.getProgressTracker("LAYOUT_BUILD")) : this.buildTracker;
    }

    @Override
    public void close() {
        this.handle.close();
    }

    public static class Handle
    implements Closeable {
        private final ProvisioningLayoutFactory layoutFactory;
        private Path workDir;
        private ClassLoader pluginsCl;
        private boolean closePluginsCl;
        private Map<String, List<ProvisioningPlugin>> loadedPlugins = Collections.emptyMap();
        private Path pluginsDir;
        private Path resourcesDir;
        private Path tmpDir;
        private int refs;

        Handle(ProvisioningLayoutFactory layoutFactory) {
            this.layoutFactory = layoutFactory;
            this.refs = 1;
        }

        protected void cleanup() {
            if (this.closePluginsCl && this.closePluginsCl) {
                try {
                    ((URLClassLoader)this.pluginsCl).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.pluginsDir != null) {
                IoUtils.recursiveDelete(this.pluginsDir);
                this.pluginsDir = null;
            }
            if (this.resourcesDir != null) {
                IoUtils.recursiveDelete(this.resourcesDir);
                this.resourcesDir = null;
            }
        }

        protected void incrementRefs() {
            ++this.refs;
        }

        private void copyResources(Path fpDir) throws ProvisioningException {
            Path fpPlugins;
            Path fpResources = fpDir.resolve("resources");
            if (Files.exists(fpResources, new LinkOption[0])) {
                this.resourcesDir = this.getWorkDir().resolve("resources");
                try {
                    IoUtils.copy(fpResources, this.resourcesDir);
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.copyFile(fpResources, this.resourcesDir), e);
                }
            }
            if (Files.exists(fpPlugins = fpDir.resolve("plugins"), new LinkOption[0])) {
                if (this.pluginsDir == null) {
                    this.pluginsDir = this.getWorkDir().resolve("plugins");
                }
                try {
                    IoUtils.copy(fpPlugins, this.pluginsDir);
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.copyFile(fpPlugins, this.pluginsDir), e);
                }
            }
        }

        protected Path newStagedDir() throws ProvisioningException {
            Path stagedDir;
            block18: {
                stagedDir = this.getWorkDir().resolve(ProvisioningLayout.STAGED);
                if (Files.exists(stagedDir, new LinkOption[0])) {
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(stagedDir);){
                        for (Path p : stream) {
                            IoUtils.recursiveDelete(p);
                        }
                        break block18;
                    }
                    catch (IOException e) {
                        throw new ProvisioningException(Errors.readDirectory(stagedDir), e);
                    }
                }
                try {
                    Files.createDirectories(stagedDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.mkdirs(stagedDir), e);
                }
            }
            return stagedDir;
        }

        protected Path getResource(String ... path) throws ProvisioningException {
            if (this.resourcesDir == null) {
                throw new ProvisioningException("Configuration does not include resources");
            }
            if (path.length == 0) {
                throw new IllegalArgumentException("Resource path is null");
            }
            if (path.length == 1) {
                return this.resourcesDir.resolve(path[0]);
            }
            Path p = this.resourcesDir;
            for (String name : path) {
                p = p.resolve(name);
            }
            return p;
        }

        protected Path getTmpPath(String ... path) {
            if (path.length == 0) {
                return this.getTmpDir();
            }
            if (path.length == 1) {
                return this.getTmpDir().resolve(path[0]);
            }
            Path p = this.getTmpDir();
            for (String name : path) {
                p = p.resolve(name);
            }
            return p;
        }

        protected ClassLoader getPluginsClassLoader() throws ProvisioningException {
            if (this.pluginsCl != null) {
                return this.pluginsCl;
            }
            this.pluginsCl = Thread.currentThread().getContextClassLoader();
            if (this.pluginsDir != null) {
                ArrayList<URL> urls = new ArrayList<URL>();
                try (Stream<Path> stream = Files.list(this.pluginsDir);){
                    Iterator i = stream.iterator();
                    while (i.hasNext()) {
                        urls.add(((Path)i.next()).toUri().toURL());
                    }
                }
                catch (IOException e) {
                    throw new ProvisioningException(Errors.readDirectory(this.pluginsDir), e);
                }
                if (!urls.isEmpty()) {
                    this.closePluginsCl = true;
                    this.pluginsCl = new URLClassLoader(urls.toArray(new URL[urls.size()]), this.pluginsCl);
                }
            }
            return this.pluginsCl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <T extends ProvisioningPlugin> void visitPlugins(FeaturePackPluginVisitor<T> visitor, Class<T> clazz) throws ProvisioningException {
            List<ProvisioningPlugin> plugins = this.loadedPlugins.get(clazz.getName());
            if (plugins == null) {
                ClassLoader pluginsCl = this.getPluginsClassLoader();
                Thread thread = Thread.currentThread();
                Iterator<T> pluginIterator = ServiceLoader.load(clazz, pluginsCl).iterator();
                plugins = Collections.emptyList();
                if (pluginIterator.hasNext()) {
                    ClassLoader ocl = thread.getContextClassLoader();
                    try {
                        thread.setContextClassLoader(pluginsCl);
                        ProvisioningPlugin plugin = (ProvisioningPlugin)pluginIterator.next();
                        plugins = CollectionUtils.add(plugins, plugin);
                        visitor.visitPlugin(plugin);
                        while (pluginIterator.hasNext()) {
                            plugin = (ProvisioningPlugin)pluginIterator.next();
                            plugins = CollectionUtils.add(plugins, plugin);
                            visitor.visitPlugin(plugin);
                        }
                    }
                    finally {
                        thread.setContextClassLoader(ocl);
                    }
                }
                this.loadedPlugins = CollectionUtils.put(this.loadedPlugins, clazz.getName(), plugins);
                return;
            }
            if (plugins.isEmpty()) {
                return;
            }
            Thread thread = Thread.currentThread();
            ClassLoader ocl = thread.getContextClassLoader();
            thread.setContextClassLoader(this.getPluginsClassLoader());
            try {
                for (ProvisioningPlugin plugin : plugins) {
                    if (!clazz.isAssignableFrom(plugin.getClass())) continue;
                    visitor.visitPlugin(plugin);
                }
            }
            finally {
                thread.setContextClassLoader(ocl);
            }
        }

        private Path getTmpDir() {
            return this.tmpDir == null ? (this.tmpDir = this.getWorkDir().resolve(ProvisioningLayout.TMP)) : this.tmpDir;
        }

        private Path getWorkDir() {
            return this.workDir == null ? (this.workDir = this.layoutFactory.newConfigLayoutDir()) : this.workDir;
        }

        public boolean isClosed() {
            return this.refs == 0;
        }

        @Override
        public void close() {
            if (this.refs == 0 || --this.refs > 0) {
                return;
            }
            this.loadedPlugins = Collections.emptyMap();
            if (this.closePluginsCl) {
                try {
                    ((URLClassLoader)this.pluginsCl).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.workDir != null) {
                IoUtils.recursiveDelete(this.workDir);
            }
            this.layoutFactory.handleClosed();
        }
    }

    public static interface FeaturePackLayout {
        public static final int DIRECT_DEP = 0;
        public static final int TRANSITIVE_DEP = 1;
        public static final int PATCH = 2;

        public FeaturePackLocation.FPID getFPID();

        public FeaturePackSpec getSpec();

        public Path getDir();

        public int getType();

        default public boolean isDirectDep() {
            return this.getType() == 0;
        }

        default public boolean isTransitiveDep() {
            return this.getType() == 1;
        }

        default public boolean isPatch() {
            return this.getType() == 2;
        }
    }
}

