/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.progresstracking;

import java.util.ArrayList;
import java.util.List;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.jboss.galleon.progresstracking.ProgressTracker;

public abstract class RecapOnPulseProgressCallback<T>
implements ProgressCallback<T> {
    protected final List<T> processedItems = new ArrayList<T>();
    protected int processedVolume;

    @Override
    public void starting(ProgressTracker<T> tracker) {
        this.processedItems.clear();
        this.processedVolume = 0;
        this.doStart(tracker);
    }

    protected abstract void doStart(ProgressTracker<T> var1);

    @Override
    public void processing(ProgressTracker<T> tracker) {
        this.processedItems.add(tracker.getItem());
    }

    @Override
    public void pulse(ProgressTracker<T> tracker) {
        int i = this.processedVolume;
        while ((long)i < tracker.getProcessedVolume()) {
            this.recap(tracker, i + 1, this.processedItems.get(i));
            ++i;
        }
        this.processedVolume = (int)tracker.getProcessedVolume();
        this.doPulse(tracker);
    }

    protected void doPulse(ProgressTracker<T> tracker) {
    }

    protected abstract void recap(ProgressTracker<T> var1, int var2, T var3);

    @Override
    public void complete(ProgressTracker<T> tracker) {
        if (this.processedVolume > 0 && (long)this.processedVolume < tracker.getProcessedVolume()) {
            while ((long)this.processedVolume < tracker.getProcessedVolume()) {
                this.recap(tracker, this.processedVolume + 1, this.processedItems.get(this.processedVolume++));
            }
        }
        this.processedItems.clear();
        this.processedVolume = 0;
        this.doComplete(tracker);
    }

    protected abstract void doComplete(ProgressTracker<T> var1);
}

