/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.jboss.galleon.Errors;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathsUtils;
import org.jboss.galleon.xml.ProvisioningXmlParser;

public class StateHistoryUtils {
    public static final int STATE_HISTORY_LIMIT = 5;

    public static void addNewUndoConfig(Path installDir, Path stagedDir, MessageWriter log) throws ProvisioningException {
        Path installHistoryList;
        Path installedConfig = PathsUtils.getProvisioningXml(installDir);
        if (!Files.exists(installedConfig, new LinkOption[0])) {
            return;
        }
        Path stagedHistoryDir = PathsUtils.getStateHistoryDir(stagedDir);
        StateHistoryUtils.mkdirs(stagedHistoryDir);
        Path installedHistoryDir = PathsUtils.getStateHistoryDir(installDir);
        List<Object> installedHistory = Collections.emptyList();
        if (Files.exists(installedHistoryDir, new LinkOption[0]) && Files.exists(installHistoryList = installedHistoryDir.resolve("list"), new LinkOption[0])) {
            try {
                installedHistory = Files.readAllLines(installHistoryList);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readFile(installHistoryList), e);
            }
        }
        int historyLimit = installedHistory.isEmpty() ? 5 : Integer.parseInt((String)installedHistory.get(0));
        String newStateId = UUID.randomUUID().toString();
        try (BufferedWriter writer = Files.newBufferedWriter(stagedHistoryDir.resolve("list"), new OpenOption[0]);){
            writer.write(String.valueOf(historyLimit));
            writer.newLine();
            if (!installedHistory.isEmpty()) {
                int offset = installedHistory.size() - historyLimit + 1;
                if (offset < 1) {
                    offset = 1;
                }
                int missingStates = 0;
                while (offset < installedHistory.size()) {
                    String stateId;
                    Path stateFile;
                    if (!Files.exists(stateFile = installedHistoryDir.resolve(stateId = (String)installedHistory.get(offset++)), new LinkOption[0])) {
                        ++missingStates;
                        continue;
                    }
                    IoUtils.copy(stateFile, stagedHistoryDir.resolve(stateId));
                    writer.write(stateId);
                    writer.newLine();
                }
                if (missingStates > 0) {
                    log.error("The state history of the current installation is corrupted referencing " + missingStates + " missing states!");
                }
            }
            if (historyLimit > 0) {
                writer.write(newStateId);
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.writeFile(stagedHistoryDir.resolve("list")), e);
        }
        try {
            IoUtils.copy(installedConfig, stagedHistoryDir.resolve(newStateId));
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.copyFile(installedConfig, stagedHistoryDir.resolve(newStateId)), e);
        }
    }

    public static void removeLastUndoConfig(Path installDir, Path stagedDir, MessageWriter log) throws ProvisioningException {
        Path installHistoryList;
        Path installedConfig = PathsUtils.getProvisioningXml(installDir);
        if (!Files.exists(installedConfig, new LinkOption[0])) {
            return;
        }
        Path installedHistoryDir = PathsUtils.getStateHistoryDir(installDir);
        List<Object> installedHistory = Collections.emptyList();
        if (Files.exists(installedHistoryDir, new LinkOption[0]) && Files.exists(installHistoryList = installedHistoryDir.resolve("list"), new LinkOption[0])) {
            try {
                installedHistory = Files.readAllLines(installHistoryList);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readFile(installHistoryList), e);
            }
        }
        if (installedHistory.size() < 2) {
            return;
        }
        Path stagedHistoryDir = PathsUtils.getStateHistoryDir(stagedDir);
        StateHistoryUtils.mkdirs(stagedHistoryDir);
        int historyLimit = installedHistory.isEmpty() ? 5 : Integer.parseInt((String)installedHistory.get(0));
        try (BufferedWriter writer = Files.newBufferedWriter(stagedHistoryDir.resolve("list"), new OpenOption[0]);){
            writer.write(String.valueOf(historyLimit));
            writer.newLine();
            if (!installedHistory.isEmpty()) {
                int offset = installedHistory.size() - historyLimit - 1;
                if (offset < 1) {
                    offset = 1;
                }
                int missingStates = 0;
                while (offset < installedHistory.size() - 1) {
                    String stateId;
                    Path stateFile;
                    if (!Files.exists(stateFile = installedHistoryDir.resolve(stateId = (String)installedHistory.get(offset++)), new LinkOption[0])) {
                        ++missingStates;
                        continue;
                    }
                    IoUtils.copy(stateFile, stagedHistoryDir.resolve(stateId));
                    writer.write(stateId);
                    writer.newLine();
                }
                if (missingStates > 0) {
                    log.error("The state history of the current installation is corrupted referencing " + missingStates + " missing states!");
                }
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.writeFile(stagedHistoryDir.resolve("list")), e);
        }
    }

    private static void mkdirs(Path stagedHistoryDir) throws ProvisioningException {
        try {
            Files.createDirectories(stagedHistoryDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.mkdirs(stagedHistoryDir), e);
        }
    }

    public static boolean isUndoAvailable(Path installDir, MessageWriter log) throws ProvisioningException {
        List<String> installedHistory;
        Path installedHistoryDir = PathsUtils.getStateHistoryDir(installDir);
        if (!Files.exists(installedHistoryDir, new LinkOption[0])) {
            return false;
        }
        Path installedHistoryList = PathsUtils.getStateHistoryFile(installDir);
        if (!Files.exists(installedHistoryList, new LinkOption[0])) {
            return false;
        }
        try {
            installedHistory = Files.readAllLines(installedHistoryList);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile(installedHistoryList), e);
        }
        if (installedHistory.size() < 2) {
            return false;
        }
        int i = installedHistory.size() - 1;
        do {
            if (Files.exists(installedHistoryDir.resolve(installedHistory.get(i--)), new LinkOption[0])) {
                return true;
            }
            log.error("The state history of the current installation is corrupted referencing missing states!");
        } while (i >= 1);
        return false;
    }

    public static ProvisioningConfig readUndoConfig(Path installDir, MessageWriter log) throws ProvisioningException {
        List<String> installedHistory;
        Path installedHistoryDir = PathsUtils.getStateHistoryDir(installDir);
        if (!Files.exists(installedHistoryDir, new LinkOption[0])) {
            throw new ProvisioningException(Errors.historyIsEmpty());
        }
        Path installedHistoryList = installedHistoryDir.resolve("list");
        if (!Files.exists(installedHistoryList, new LinkOption[0])) {
            throw new ProvisioningException(Errors.historyIsEmpty());
        }
        try {
            installedHistory = Files.readAllLines(installedHistoryList);
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile(installedHistoryList), e);
        }
        if (installedHistory.size() < 2) {
            throw new ProvisioningException(Errors.historyIsEmpty());
        }
        int i = installedHistory.size() - 1;
        do {
            Path statePath;
            if (Files.exists(statePath = installedHistoryDir.resolve(installedHistory.get(i--)), new LinkOption[0])) {
                return ProvisioningXmlParser.parse(statePath);
            }
            log.error("The state history of the current installation is corrupted referencing missing states!");
        } while (i >= 1);
        throw new ProvisioningException(Errors.historyIsEmpty());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int readStateHistoryLimit(Path installDir, MessageWriter log) throws ProvisioningException {
        Path installedHistoryList = PathsUtils.getStateHistoryFile(installDir);
        if (!Files.exists(installedHistoryList, new LinkOption[0])) {
            return 5;
        }
        try (BufferedReader reader = Files.newBufferedReader(installedHistoryList);){
            String line = reader.readLine();
            if (line == null) return 5;
            int n = Integer.parseInt(line);
            return n;
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile(installedHistoryList), e);
        }
    }

    public static int writeStateHistoryLimit(Path installDir, int limit, MessageWriter log) throws ProvisioningException {
        if (limit < 0) {
            throw new ProvisioningException("State history limit can not be a negative value: " + limit);
        }
        Path installedHistoryDir = PathsUtils.getStateHistoryDir(installDir);
        if (!Files.exists(installedHistoryDir, new LinkOption[0])) {
            StateHistoryUtils.mkdirs(installedHistoryDir);
        }
        Path installedHistoryList = installedHistoryDir.resolve("list");
        List<Object> installedHistory = Collections.emptyList();
        if (Files.exists(installedHistoryList, new LinkOption[0])) {
            try {
                installedHistory = Files.readAllLines(installedHistoryList);
            }
            catch (IOException e) {
                throw new ProvisioningException(Errors.readFile(installedHistoryList), e);
            }
        }
        try (BufferedWriter writer = Files.newBufferedWriter(installedHistoryList, new OpenOption[0]);){
            writer.write(String.valueOf(limit));
            writer.newLine();
            int offset = installedHistory.size() - limit;
            if (offset < 1) {
                offset = 1;
            }
            int missingStates = 0;
            while (offset < installedHistory.size()) {
                String stateId;
                Path stateFile;
                if (!Files.exists(stateFile = installedHistoryDir.resolve(stateId = (String)installedHistory.get(offset++)), new LinkOption[0])) {
                    ++missingStates;
                    continue;
                }
                writer.write(stateId);
                writer.newLine();
            }
            if (missingStates > 0) {
                log.error("The state history of the current installation is corrupted referencing " + missingStates + " missing states!");
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile(installedHistoryList), e);
        }
        return 5;
    }
}

