/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.PrintStream;
import java.util.logging.LogManager;
import org.aesh.command.AeshCommandRuntimeBuilder;
import org.aesh.command.Command;
import org.aesh.command.CommandRuntime;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.converter.ConverterInvocation;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.settings.Settings;
import org.aesh.command.settings.SettingsBuilder;
import org.aesh.command.validator.ValidatorInvocation;
import org.aesh.extensions.clear.Clear;
import org.aesh.readline.ReadlineConsole;
import org.jboss.galleon.cli.PmExitCommand;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.UninstallCommand;
import org.jboss.galleon.cli.cmd.featurepack.FeaturePackCommand;
import org.jboss.galleon.cli.cmd.filesystem.CdCommand;
import org.jboss.galleon.cli.cmd.filesystem.LsCommand;
import org.jboss.galleon.cli.cmd.filesystem.PmMkdir;
import org.jboss.galleon.cli.cmd.filesystem.PmRm;
import org.jboss.galleon.cli.cmd.filesystem.PwdCommand;
import org.jboss.galleon.cli.cmd.mvn.MavenCommand;
import org.jboss.galleon.cli.cmd.plugin.InstallCommand;
import org.jboss.galleon.cli.cmd.state.SearchCommand;
import org.jboss.galleon.cli.cmd.state.StateCommand;
import org.jboss.galleon.cli.cmd.state.feature.FeatureCommand;
import org.jboss.galleon.cli.cmd.universe.UniverseCommand;
import org.jboss.galleon.cli.config.Configuration;

public class CliMain {
    public static void main(String[] args) throws Exception {
        Configuration config = Configuration.parse();
        PmSession pmSession = new PmSession(config);
        pmSession.getUniverse().resolveBuiltinUniverse();
        Settings settings = CliMain.buildSettings(pmSession, null);
        ReadlineConsole console = new ReadlineConsole(settings);
        pmSession.setAeshContext(console.context());
        console.setPrompt(PmSession.buildPrompt(settings.aeshContext()));
        console.start();
    }

    private static boolean overrideLogging() {
        return LogManager.getLogManager().getClass() == LogManager.class && System.getProperty("java.util.logging.config.class") == null && System.getProperty("java.util.logging.config.file") == null;
    }

    private static Settings buildSettings(PmSession pmSession, PrintStream out) throws CommandLineParserException {
        Settings<? extends Command<? extends CommandInvocation>, ? extends CommandInvocation, ? extends ConverterInvocation, ? extends CompleterInvocation, ? extends ValidatorInvocation, ? extends OptionActivator, ? extends CommandActivator> settings = SettingsBuilder.builder().logging(CliMain.overrideLogging()).commandRegistry(CliMain.buildRegistry(pmSession)).enableOperatorParser(true).persistHistory(true).commandActivatorProvider(pmSession).historyFile(pmSession.getPmConfiguration().getHistoryFile()).echoCtrl(false).enableExport(false).enableAlias(false).completerInvocationProvider(pmSession).optionActivatorProvider(pmSession).commandInvocationProvider(pmSession).outputStream(out).build();
        pmSession.setOut(settings.stdOut());
        pmSession.setErr(settings.stdErr());
        return settings;
    }

    private static CommandRegistry buildRegistry(PmSession pmSession) throws CommandLineParserException {
        InstallCommand install = new InstallCommand(pmSession);
        FeatureCommand feature = new FeatureCommand(pmSession);
        StateCommand state = new StateCommand(pmSession);
        AeshCommandRegistryBuilder builder = new AeshCommandRegistryBuilder().command(Clear.class).command(FeaturePackCommand.class).command(MavenCommand.class).command(feature).command(state).command(install.createCommand()).command(UninstallCommand.class).command(CdCommand.class).command(PmExitCommand.class).command(LsCommand.class).command(PmMkdir.class).command(PmRm.class).command(PwdCommand.class).command(SearchCommand.class).command(UniverseCommand.class);
        StateCommand.addActionCommands(builder);
        return builder.create();
    }

    public static CommandRuntime newRuntime(PmSession session, PrintStream out) throws CommandLineParserException {
        AeshCommandRuntimeBuilder builder = AeshCommandRuntimeBuilder.builder();
        builder.settings(CliMain.buildSettings(session, out));
        CommandRuntime runtime = builder.build();
        session.setAeshContext(runtime.getAeshContext());
        return runtime;
    }
}

