/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.PrintStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.activator.CommandActivatorProvider;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.activator.OptionActivatorProvider;
import org.aesh.command.completer.CompleterInvocation;
import org.aesh.command.completer.CompleterInvocationProvider;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.invocation.CommandInvocationProvider;
import org.aesh.readline.AeshContext;
import org.aesh.readline.Prompt;
import org.aesh.utils.Config;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.jboss.galleon.DefaultMessageWriter;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CliMavenArtifactRepositoryManager;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmOptionActivator;
import org.jboss.galleon.cli.UniverseManager;
import org.jboss.galleon.cli.config.Configuration;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.cli.resolver.ResourceResolver;
import org.jboss.galleon.cli.tracking.ProgressTrackers;
import org.jboss.galleon.layout.ProvisioningLayoutFactory;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.UniverseResolver;
import org.jboss.galleon.universe.UniverseSpec;
import org.jboss.galleon.universe.maven.repo.MavenRepoManager;

public class PmSession
implements CommandInvocationProvider<PmCommandInvocation>,
CompleterInvocationProvider<PmCompleterInvocation>,
CommandActivatorProvider,
OptionActivatorProvider<OptionActivator> {
    private PrintStream out;
    private PrintStream err;
    private final Configuration config;
    private State state;
    private FeatureContainer exploredContainer;
    private String currentPath;
    private final CliMavenArtifactRepositoryManager maven;
    private final MavenListener mavenListener;
    private UniverseManager universe;
    private final ResourceResolver resolver;
    private final ProvisioningLayoutFactory layoutFactory;
    private AeshContext ctx;
    private boolean rethrow = false;
    private boolean enableTrackers = true;

    public PmSession(Configuration config) throws Exception {
        this.config = config;
        this.mavenListener = new MavenListener();
        this.maven = new CliMavenArtifactRepositoryManager(config.getMavenConfig(), this.mavenListener);
        UniverseResolver universeResolver = ((UniverseResolver.Builder)UniverseResolver.builder().addArtifactResolver(this.maven)).build();
        this.universe = new UniverseManager(this, config, this.maven, universeResolver);
        this.layoutFactory = ProvisioningLayoutFactory.getInstance(universeResolver);
        this.resolver = new ResourceResolver(this);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.close()));
    }

    public void enableTrackers(boolean enable) {
        this.enableTrackers = enable;
    }

    public boolean isTrackersEnabled() {
        return this.enableTrackers;
    }

    public void registerTrackers() {
        if (this.enableTrackers) {
            ProgressTrackers.registerTrackers(this);
        }
    }

    public void unregisterTrackers() {
        ProgressTrackers.unregisterTrackers(this);
    }

    public void throwException() {
        this.rethrow = true;
    }

    public boolean isExceptionRethrown() {
        return this.rethrow;
    }

    public void close() {
        try {
            if (this.state != null) {
                this.state.close();
            }
        }
        finally {
            try {
                this.universe.close();
            }
            finally {
                this.layoutFactory.close();
            }
        }
    }

    MavenRepoManager getMavenRepoManager() {
        return this.maven;
    }

    void setAeshContext(AeshContext ctx) {
        this.ctx = ctx;
    }

    public AeshContext getAeshContext() {
        return this.ctx;
    }

    public ProvisioningManager newProvisioningManager(Path installation, boolean verbose) throws ProvisioningException {
        ProvisioningManager.Builder builder = ProvisioningManager.builder();
        builder.setLayoutFactory(this.getLayoutFactory());
        if (installation != null) {
            builder.setInstallationHome(installation);
        }
        builder.setMessageWriter(this.getMessageWriter(verbose));
        return builder.build();
    }

    public MessageWriter getMessageWriter(boolean verbose) {
        if (this.enableTrackers) {
            if (verbose) {
                this.unregisterTrackers();
            } else {
                this.registerTrackers();
            }
        } else {
            this.unregisterTrackers();
        }
        return new DefaultMessageWriter(this.out, this.err, verbose);
    }

    public ProvisioningLayoutFactory getLayoutFactory() {
        return this.layoutFactory;
    }

    public ResourceResolver getResolver() {
        return this.resolver;
    }

    public UniverseManager getUniverse() {
        return this.universe;
    }

    public FeaturePackLocation getResolvedLocation(String location) throws ProvisioningException {
        if (location.endsWith("/") || location.endsWith("#")) {
            location = location.substring(0, location.length() - 1);
        }
        if (!location.contains("@") && !location.contains(":")) {
            location = new FeaturePackLocation(this.universe.getDefaultUniverseSpec(), location, null, null, null).toString();
        }
        FeaturePackLocation loc = FeaturePackLocation.fromString(location);
        return this.getResolvedLocation(loc);
    }

    public void commandStart(PmCommandInvocation session) {
        this.maven.commandStart();
        ProgressTrackers.commandStart(session);
    }

    public void commandEnd(PmCommandInvocation session) {
        this.maven.commandEnd();
        ProgressTrackers.commandEnd(session);
    }

    public void setState(State session) {
        this.state = session;
    }

    public State getState() {
        return this.state;
    }

    public void setExploredContainer(FeatureContainer exploredContainer) {
        this.exploredContainer = exploredContainer;
    }

    public FeatureContainer getExploredContainer() {
        return this.exploredContainer;
    }

    public FeatureContainer getContainer() {
        if (this.state != null) {
            return this.state.getContainer();
        }
        if (this.exploredContainer != null) {
            return this.exploredContainer;
        }
        return null;
    }

    public String getCurrentPath() {
        if (this.state != null) {
            return this.state.getPath();
        }
        return this.currentPath;
    }

    public void setCurrentPath(String currentPath) {
        if (this.state != null) {
            this.state.setPath(currentPath);
        }
        this.currentPath = currentPath;
    }

    public void println(String txt) {
        this.out.print(txt + Config.getLineSeparator());
    }

    public void print(String txt) {
        this.out.print(txt);
    }

    public Configuration getPmConfiguration() {
        return this.config;
    }

    public static Prompt buildPrompt(AeshContext aeshCtx) {
        return PmSession.buildPrompt(aeshCtx.getCurrentWorkingDirectory().getName());
    }

    public static Prompt buildPrompt(String name) {
        return new Prompt('[' + name + "]$ ");
    }

    public static Path getWorkDir(AeshContext aeshCtx) {
        return Paths.get(aeshCtx.getCurrentWorkingDirectory().getAbsolutePath(), new String[0]);
    }

    @Override
    public PmCommandInvocation enhanceCommandInvocation(CommandInvocation commandInvocation) {
        return new PmCommandInvocation(this, this.out, this.err, commandInvocation);
    }

    void setOut(PrintStream out) {
        this.out = out;
    }

    void setErr(PrintStream err) {
        this.err = err;
    }

    @Override
    public PmCompleterInvocation enhanceCompleterInvocation(CompleterInvocation completerInvocation) {
        return new PmCompleterInvocation(completerInvocation, this);
    }

    public CommandActivator enhanceCommandActivator(CommandActivator ca) {
        if (ca instanceof PmCommandActivator) {
            ((PmCommandActivator)ca).setPmSession(this);
        }
        return ca;
    }

    @Override
    public OptionActivator enhanceOptionActivator(OptionActivator oa) {
        if (oa instanceof PmOptionActivator) {
            ((PmOptionActivator)oa).setPmSession(this);
        }
        return oa;
    }

    public boolean existsInLocalRepository(FeaturePackLocation.FPID fpid) throws ProvisioningException {
        FeaturePackLocation loc = this.getResolvedLocation(fpid.getLocation());
        Object producer = this.universe.getUniverse(loc.getUniverse()).getProducer(loc.getProducerName());
        boolean hasFrequency = false;
        if (producer != null) {
            hasFrequency = producer.hasFrequencies();
        }
        String freq = loc.getFrequency() == null && hasFrequency ? "alpha" : loc.getFrequency();
        loc = new FeaturePackLocation(loc.getUniverse(), loc.getProducerName(), loc.getChannelName(), freq, loc.getBuild());
        return this.universe.isResolved(loc);
    }

    public void downloadFp(FeaturePackLocation.FPID fpid) throws ProvisioningException {
        this.universe.resolve(this.getResolvedLocation(fpid.getLocation()));
    }

    private FeaturePackLocation getResolvedLocation(FeaturePackLocation fplocation) throws ProvisioningException {
        UniverseSpec spec = fplocation.getUniverse();
        if (spec != null) {
            if (spec.getLocation() == null && (spec = this.universe.getUniverseSpec(spec.getFactory())) == null) {
                throw new ProvisioningException("Unknown universe for " + fplocation);
            }
        } else {
            spec = this.universe.getDefaultUniverseSpec();
        }
        return new FeaturePackLocation(spec, fplocation.getProducerName(), fplocation.getChannelName(), fplocation.getFrequency(), fplocation.getBuild());
    }

    public FeaturePackLocation getExposedLocation(FeaturePackLocation fplocation) {
        UniverseSpec spec = fplocation.getUniverse();
        boolean rewrite = false;
        String name = this.getUniverse().getUniverseName(spec);
        if (name != null) {
            rewrite = true;
            spec = new UniverseSpec(name, null);
        } else if (this.getUniverse().getDefaultUniverseSpec().equals(spec)) {
            rewrite = true;
            spec = null;
        }
        if (rewrite) {
            fplocation = new FeaturePackLocation(spec, fplocation.getProducerName(), fplocation.getChannelName(), fplocation.getFrequency(), fplocation.getBuild());
        }
        return fplocation;
    }

    public void enableMavenTrace(boolean b) {
        this.mavenListener.setActive(b);
    }

    private class MavenListener
    implements RepositoryListener {
        private static final String MAVEN = "[MAVEN] ";
        private boolean active;

        private MavenListener() {
        }

        void setActive(boolean active) {
            this.active = active;
        }

        @Override
        public void artifactDownloaded(RepositoryEvent re) {
            if (this.active && re != null) {
                String artifact = re.getArtifact().getGroupId() + ":" + re.getArtifact().getArtifactId() + ":" + re.getArtifact().getVersion() + ":" + re.getArtifact().getExtension();
                if (re.getException() == null) {
                    PmSession.this.println("[MAVEN] downloaded " + artifact + " from " + re.getRepository().getId());
                } else if (re.getException() instanceof ArtifactNotFoundException) {
                    PmSession.this.println("[MAVEN] artifact " + artifact + " not found in " + re.getRepository().getId());
                } else {
                    PmSession.this.println(MAVEN + re.getException().getLocalizedMessage() + " while downloading artifact " + artifact);
                }
            }
        }

        @Override
        public void artifactDownloading(RepositoryEvent re) {
            if (this.active && re != null) {
                PmSession.this.println("[MAVEN] attempting to download " + re.getArtifact().getGroupId() + ":" + re.getArtifact().getArtifactId() + ":" + re.getArtifact().getVersion() + ":" + re.getArtifact().getExtension() + (re.getRepository() != null ? " from " + re.getRepository().getId() : ""));
            }
        }

        @Override
        public void artifactDescriptorInvalid(RepositoryEvent re) {
        }

        @Override
        public void artifactDescriptorMissing(RepositoryEvent re) {
        }

        @Override
        public void metadataInvalid(RepositoryEvent re) {
        }

        @Override
        public void artifactResolving(RepositoryEvent re) {
        }

        @Override
        public void artifactResolved(RepositoryEvent re) {
        }

        @Override
        public void metadataResolving(RepositoryEvent re) {
        }

        @Override
        public void metadataResolved(RepositoryEvent re) {
        }

        @Override
        public void metadataDownloading(RepositoryEvent re) {
        }

        @Override
        public void metadataDownloaded(RepositoryEvent re) {
        }

        @Override
        public void artifactInstalling(RepositoryEvent re) {
        }

        @Override
        public void artifactInstalled(RepositoryEvent re) {
        }

        @Override
        public void metadataInstalling(RepositoryEvent re) {
        }

        @Override
        public void metadataInstalled(RepositoryEvent re) {
        }

        @Override
        public void artifactDeploying(RepositoryEvent re) {
        }

        @Override
        public void artifactDeployed(RepositoryEvent re) {
        }

        @Override
        public void metadataDeploying(RepositoryEvent re) {
        }

        @Override
        public void metadataDeployed(RepositoryEvent re) {
        }
    }
}

