/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.io.Resource;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.ProvisioningCommand;
import org.jboss.galleon.cli.cmd.CliErrors;

@CommandDefinition(name="export", description="Saves current provisioned spec into the specified file.")
public class ProvisionedSpecExportCommand
extends ProvisioningCommand {
    @Argument(description="File to save the provisioned spec too.", required=true)
    private Resource fileArg;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        if (this.fileArg == null) {
            throw new CommandExecutionException("Missing required file path argument.");
        }
        Resource specResource = this.fileArg.resolve(session.getAeshContext().getCurrentWorkingDirectory()).get(0);
        Path targetFile = Paths.get(specResource.getAbsolutePath(), new String[0]);
        try {
            this.getManager(session).exportProvisioningConfig(targetFile);
        }
        catch (IOException | ProvisioningException e) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.exportProvisionedFailed(), e);
        }
    }
}

