/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.plugin;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.plugin.AbstractPluginsCommand;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;
import org.jboss.galleon.cli.resolver.PluginResolver;
import org.jboss.galleon.layout.FeaturePackDescriber;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.PathsUtils;

public class InstallCommand
extends AbstractPluginsCommand {
    public static final String FILE_OPTION_NAME = "file";

    public InstallCommand(PmSession pmSession) {
        super(pmSession);
    }

    @Override
    protected void runCommand(PmCommandInvocation session, Map<String, String> options, FeaturePackLocation loc) throws CommandExecutionException {
        try {
            String filePath = (String)this.getValue(FILE_OPTION_NAME);
            ProvisioningManager manager = this.getManager(session);
            if (filePath != null) {
                Path workDir = PmSession.getWorkDir(session.getAeshContext());
                Path p = workDir.resolve(filePath);
                manager.install(p, true);
            } else {
                manager.install(loc, options);
            }
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.installFailed(), ex);
        }
    }

    @Override
    protected Set<PluginOption> getPluginOptions(FeaturePackLocation loc) throws ProvisioningException {
        try {
            String file = (String)this.getValue(FILE_OPTION_NAME);
            if (file == null) {
                file = this.getOptionValue(FILE_OPTION_NAME);
            }
            if (file == null) {
                return this.pmSession.getResolver().get(loc.toString(), PluginResolver.newResolver(this.pmSession, loc)).getInstall();
            }
            return this.pmSession.getResolver().get(file, PluginResolver.newResolver(this.pmSession, loc)).getInstall();
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
            throw new ProvisioningException(ex);
        }
        catch (ExecutionException ex) {
            throw new ProvisioningException(ex.getCause());
        }
    }

    @Override
    protected String getName() {
        return "install";
    }

    @Override
    protected String getDescription() {
        return "Installs specified feature-pack";
    }

    @Override
    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        ProcessedOption dir = ProcessedOptionBuilder.builder().name("dir").hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("Target installation directory.").completer(FileOptionCompleter.class).build();
        options.add(dir);
        ProcessedOption file = ProcessedOptionBuilder.builder().name(FILE_OPTION_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).activator(new FileOptionActivator()).description("Path to a Feature-pack.").completer(FileOptionCompleter.class).build();
        options.add(file);
        return options;
    }

    @Override
    protected String getId(PmSession session) throws CommandExecutionException {
        String filePath = (String)this.getValue(FILE_OPTION_NAME);
        if (filePath == null) {
            return super.getId(session);
        }
        Path workDir = PmSession.getWorkDir(session.getAeshContext());
        Path path = workDir.resolve(filePath);
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            return FeaturePackDescriber.readSpec(path).getFPID().toString();
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(session, CliErrors.retrieveFeaturePackID(), ex);
        }
    }

    @Override
    protected OptionActivator getArgumentActivator() {
        return new ArgOptionActivator();
    }

    @Override
    protected void doValidateOptions(PmCommandInvocation invoc) throws CommandExecutionException {
        String filePath = (String)this.getValue(FILE_OPTION_NAME);
        if (filePath == null) {
            super.doValidateOptions(invoc);
            return;
        }
        String arg = (String)this.getValue("org.jboss.pm.tool.arg");
        if (arg != null) {
            throw new CommandExecutionException("Only one of file or Feature-pack location is allowed.");
        }
        Path workDir = PmSession.getWorkDir(invoc.getAeshContext());
        Path p = workDir.resolve(filePath);
        if (!Files.exists(p, new LinkOption[0])) {
            throw new CommandExecutionException(p + " doesn't exist.");
        }
    }

    @Override
    protected boolean canComplete(PmSession pmSession) {
        String targetDirArg = (String)this.getValue("dir");
        if (targetDirArg == null) {
            targetDirArg = this.getOptionValue("dir");
        }
        if (targetDirArg != null) {
            return true;
        }
        Path workDir = PmSession.getWorkDir(pmSession.getAeshContext());
        return Files.exists(PathsUtils.getProvisioningXml(workDir), new LinkOption[0]) || workDir.toFile().list().length == 0;
    }

    @Override
    protected Path getInstallationHome(AeshContext context) {
        String targetDirArg = (String)this.getValue("dir");
        Path workDir = PmSession.getWorkDir(context);
        return targetDirArg == null ? workDir : workDir.resolve(targetDirArg);
    }

    @Override
    protected PmCommandActivator getActivator() {
        return new NoStateCommandActivator();
    }

    private class FileOptionActivator
    implements OptionActivator {
        private FileOptionActivator() {
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.argument();
            return opt == null || opt.value() == null;
        }
    }

    private class ArgOptionActivator
    implements OptionActivator {
        private ArgOptionActivator() {
        }

        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck(InstallCommand.FILE_OPTION_NAME);
            return opt == null || opt.value() == null;
        }
    }
}

