/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.plugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmOptionActivator;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.AbstractDynamicCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.plugin.AbstractProvisionWithPlugins;
import org.jboss.galleon.cli.cmd.state.StateNoExplorationActivator;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.cli.resolver.PluginResolver;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackPluginVisitor;
import org.jboss.galleon.plugin.InstallPlugin;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.xml.ProvisioningXmlParser;

public class StateProvisionCommand
extends AbstractProvisionWithPlugins {
    public StateProvisionCommand(PmSession pmSession) {
        super(pmSession);
    }

    @Override
    protected String getName() {
        return "provision";
    }

    @Override
    protected String getDescription() {
        return "Install from a provisioning file or the current state";
    }

    @Override
    protected List<AbstractDynamicCommand.DynamicOption> getDynamicOptions(State state, String id) throws Exception {
        Set<PluginOption> opts;
        ArrayList<AbstractDynamicCommand.DynamicOption> options = new ArrayList<AbstractDynamicCommand.DynamicOption>();
        if (state != null) {
            ProvisioningRuntime rt = state.getRuntime();
            opts = this.getPluginOptions(rt);
        } else {
            String file = this.getFile();
            if (file == null) {
                return Collections.emptyList();
            }
            ProvisioningConfig config = ProvisioningXmlParser.parse(this.getAbsolutePath(file, this.pmSession.getAeshContext()));
            opts = this.pmSession.getResolver().get(id, PluginResolver.newResolver(this.pmSession, config)).getInstall();
        }
        for (PluginOption opt : opts) {
            AbstractDynamicCommand.DynamicOption dynOption = new AbstractDynamicCommand.DynamicOption(this, opt.getName(), opt.isRequired(), opt.isAcceptsValue());
            options.add(dynOption);
        }
        return options;
    }

    @Override
    protected boolean canComplete(PmSession pmSession) {
        if (pmSession.getState() != null) {
            return true;
        }
        return super.canComplete(pmSession);
    }

    private Set<PluginOption> getPluginOptions(ProvisioningRuntime runtime) throws ProvisioningException {
        final HashSet<PluginOption> pluginOptions = new HashSet<PluginOption>();
        FeaturePackPluginVisitor<InstallPlugin> visitor = new FeaturePackPluginVisitor<InstallPlugin>(){

            @Override
            public void visitPlugin(InstallPlugin plugin) throws ProvisioningException {
                pluginOptions.addAll(plugin.getOptions().values());
            }
        };
        runtime.visitPlugins(visitor, InstallPlugin.class);
        return pluginOptions;
    }

    @Override
    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        options.add(ProcessedOptionBuilder.builder().name("org.jboss.pm.tool.arg").hasValue(true).description("File describing the desired provisioned state.").type(String.class).optionType(OptionType.ARGUMENT).completer(FileOptionCompleter.class).activator(FileActivator.class).build());
        return options;
    }

    @Override
    protected PmCommandActivator getActivator() {
        return new StateNoExplorationActivator();
    }

    @Override
    protected void doValidateOptions(PmCommandInvocation invoc) throws CommandExecutionException {
        String filePath = this.getFile();
        if (filePath != null && !Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            throw new CommandExecutionException(filePath + " doesn't exist");
        }
    }

    private String getFile() {
        String file = (String)this.getValue("org.jboss.pm.tool.arg");
        if (file == null) {
            file = this.getArgumentValue();
        }
        return file;
    }

    @Override
    protected void doRunCommand(PmCommandInvocation invoc, Map<String, String> options) throws CommandExecutionException {
        if (invoc.getPmSession().getState() != null) {
            State state = invoc.getPmSession().getState();
            try {
                this.getManager(invoc).provision(state.getConfig(), options);
            }
            catch (ProvisioningException ex) {
                throw new CommandExecutionException(invoc.getPmSession(), CliErrors.provisioningFailed(), ex);
            }
        }
        String file = this.getFile();
        if (file == null) {
            throw new CommandExecutionException("No provisioning file provided.");
        }
        Path provisioningFile = this.getAbsolutePath(file, invoc.getAeshContext());
        if (!Files.exists(provisioningFile, new LinkOption[0])) {
            throw new CommandExecutionException("Failed to locate provisioning file " + provisioningFile.toAbsolutePath());
        }
        try {
            this.getManager(invoc).provision(provisioningFile, options);
        }
        catch (ProvisioningException e) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.provisioningFailed(), e);
        }
        Path home = this.getInstallationDirectory(invoc.getAeshContext());
        if (Files.exists(home, new LinkOption[0]) && invoc.getPmSession().getState() != null) {
            try {
                invoc.println("Installation done in " + home.toFile().getCanonicalPath());
            }
            catch (IOException ex) {
                throw new CommandExecutionException(invoc.getPmSession(), CliErrors.retrievePath(), ex);
            }
        } else if (invoc.getPmSession().getState() != null) {
            invoc.println("Nothing to install");
        }
    }

    public static class FileActivator
    extends PmOptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            return this.getPmSession().getState() == null;
        }
    }
}

