/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.nio.file.Path;
import org.aesh.command.CommandDefinition;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.option.Argument;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;
import org.jboss.galleon.cli.model.state.State;

@CommandDefinition(name="edit", description="Edit an installation or a provisioning xml file", activator=NoStateCommandActivator.class)
public class StateEditCommand
extends PmSessionCommand {
    @Argument(completer=FileOptionCompleter.class, required=false, description="Installation directory or provisionng file.")
    protected String dir;

    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        State session;
        if (invoc.getPmSession().getContainer() != null) {
            throw new CommandExecutionException("Provisioning session already set");
        }
        try {
            session = new State(invoc.getPmSession(), this.getInstallationHome(invoc.getAeshContext()));
        }
        catch (Exception ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.readContentFailed(), ex);
        }
        invoc.getPmSession().setState(session);
        invoc.setPrompt(PmSession.buildPrompt("/"));
        invoc.println("Entering provisioning composition mode. Use 'fp add' command to add content. Call 'state leave' to leave this mode.");
    }

    protected Path getInstallationHome(AeshContext context) {
        Path workDir = PmSession.getWorkDir(context);
        return this.dir == null ? PmSession.getWorkDir(context) : workDir.resolve(this.dir);
    }
}

