/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.util.ArrayList;
import java.util.HashMap;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractStateCommand;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.state.InfoTypeCompleter;
import org.jboss.galleon.cli.cmd.state.StateInfoUtil;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.resolver.PluginResolver;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.universe.FeaturePackLocation;

@CommandDefinition(name="info", description="Display information for an installation directory or editing state")
public class StateInfoCommand
extends AbstractStateCommand {
    @Option(completer=InfoTypeCompleter.class)
    private String type;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        try {
            ProvisioningConfig config = this.getProvisioningConfig(invoc.getPmSession());
            if (!config.hasFeaturePackDeps()) {
                return;
            }
            if (this.type == null) {
                this.displayFeaturePacks(invoc, config);
                return;
            }
            try (ProvisioningLayout<FeaturePackLayout> layout = invoc.getPmSession().getLayoutFactory().newConfigLayout(config);){
                switch (this.type) {
                    case "all": {
                        FeatureContainer container = this.getFeatureContainer(invoc.getPmSession(), layout);
                        this.displayFeaturePacks(invoc, config);
                        this.displayDependencies(invoc, layout);
                        this.displayPatches(invoc, layout);
                        this.displayConfigs(invoc, container);
                        this.displayOptions(invoc, layout);
                        return;
                    }
                    case "configs": {
                        FeatureContainer container = this.getFeatureContainer(invoc.getPmSession(), layout);
                        String configs = this.buildConfigs(invoc, container);
                        if (configs == null) return;
                        this.displayFeaturePacks(invoc, config);
                        invoc.println(configs);
                        return;
                    }
                    case "dependencies": {
                        String deps = this.buildDependencies(invoc, layout);
                        if (deps == null) return;
                        this.displayFeaturePacks(invoc, config);
                        invoc.println(deps);
                        return;
                    }
                    case "options": {
                        String options = this.buildOptions(layout);
                        if (options == null) return;
                        this.displayFeaturePacks(invoc, config);
                        invoc.println(options);
                        return;
                    }
                    case "patches": {
                        String patches = this.buildPatches(invoc, layout);
                        if (patches == null) return;
                        this.displayFeaturePacks(invoc, config);
                        invoc.println(patches);
                        return;
                    }
                    default: {
                        throw new CommandExecutionException(CliErrors.invalidInfoType());
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.infoFailed(), ex);
        }
    }

    private void displayConfigs(PmCommandInvocation invoc, FeatureContainer container) {
        String str = this.buildConfigs(invoc, container);
        if (str != null) {
            invoc.println(str);
        }
    }

    private String buildConfigs(PmCommandInvocation invoc, FeatureContainer container) {
        return StateInfoUtil.buildConfigs(container.getFinalConfigs());
    }

    private void displayFeaturePacks(PmCommandInvocation invoc, ProvisioningConfig config) {
        StateInfoUtil.printFeaturePacks(invoc, config.getFeaturePackDeps());
    }

    private void displayDependencies(PmCommandInvocation invoc, ProvisioningLayout<FeaturePackLayout> layout) throws ProvisioningException {
        String str = this.buildDependencies(invoc, layout);
        if (str != null) {
            invoc.println(str);
        }
    }

    private String buildDependencies(PmCommandInvocation invoc, ProvisioningLayout<FeaturePackLayout> layout) throws ProvisioningException {
        HashMap<FeaturePackLocation.FPID, FeaturePackConfig> configs = new HashMap<FeaturePackLocation.FPID, FeaturePackConfig>();
        ArrayList<FeaturePackLocation> dependencies = new ArrayList<FeaturePackLocation>();
        for (FeaturePackLayout fpLayout : layout.getOrderedFeaturePacks()) {
            boolean isProduct = true;
            for (FeaturePackLayout fpLayout2 : layout.getOrderedFeaturePacks()) {
                if (!fpLayout2.getSpec().hasTransitiveDep(fpLayout.getFPID().getProducer()) && fpLayout2.getSpec().getFeaturePackDep(fpLayout.getFPID().getProducer()) == null) continue;
                isProduct = false;
                break;
            }
            if (isProduct) continue;
            FeaturePackLocation loc = invoc.getPmSession().getExposedLocation(fpLayout.getFPID().getLocation());
            dependencies.add(loc);
            FeaturePackConfig transitiveConfig = layout.getConfig().getTransitiveDep(fpLayout.getFPID().getProducer());
            configs.put(loc.getFPID(), transitiveConfig);
        }
        return StateInfoUtil.buildDependencies(dependencies, configs);
    }

    private void displayPatches(PmCommandInvocation invoc, ProvisioningLayout<FeaturePackLayout> layout) throws ProvisioningException {
        String str = this.buildPatches(invoc, layout);
        if (str != null) {
            invoc.println(str);
        }
    }

    private String buildPatches(PmCommandInvocation invoc, ProvisioningLayout<FeaturePackLayout> layout) throws ProvisioningException {
        return StateInfoUtil.buildPatches(invoc, layout);
    }

    private String buildOptions(ProvisioningLayout<FeaturePackLayout> layout) throws ProvisioningException {
        return StateInfoUtil.buildOptions(PluginResolver.resolvePlugins(layout));
    }

    private void displayOptions(PmCommandInvocation commandInvocation, ProvisioningLayout layout) throws ProvisioningException {
        String str = this.buildOptions(layout);
        if (str != null) {
            commandInvocation.println(str);
        }
    }
}

