/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.AbstractStateCommand;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;

@CommandDefinition(name="set-history-limit", description="Set the history limit.", activator=NoStateCommandActivator.class)
public class StateSetHistoryLimitCommand
extends AbstractStateCommand {
    @Argument(required=true)
    private String size;

    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        try {
            int s;
            try {
                s = Integer.parseInt(this.size);
            }
            catch (NumberFormatException ex) {
                throw new CommandExecutionException(CliErrors.invalidHistoryLimit(this.size));
            }
            ProvisioningManager mgr = invoc.getPmSession().newProvisioningManager(this.getInstallationDirectory(invoc.getAeshContext()), false);
            mgr.setStateHistoryLimit(s);
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.setHistoryLimitFailed(), ex);
        }
    }
}

