/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.io.IOException;
import java.nio.file.Path;
import org.aesh.command.CommandDefinition;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.option.Option;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.AbstractStateCommand;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmOptionActivator;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.model.state.State;

@CommandDefinition(name="undo", description="Undo the last provisioning command")
public class StateUndoCommand
extends AbstractStateCommand {
    @Option(name="verbose", required=false, hasValue=false, activator=VerboseActivator.class)
    private boolean verbose;

    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        try {
            if (invoc.getPmSession().getState() == null) {
                Path p = this.getInstallationDirectory(invoc.getAeshContext());
                ProvisioningManager mgr = invoc.getPmSession().newProvisioningManager(p, this.verbose);
                mgr.undo();
            } else {
                State state = invoc.getPmSession().getState();
                if (!state.hasActions()) {
                    throw new ProvisioningException(Errors.historyIsEmpty());
                }
                state.pop(invoc.getPmSession());
            }
        }
        catch (IOException | ProvisioningException ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.undoFailed(), ex);
        }
    }

    public static class VerboseActivator
    extends PmOptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            return this.getPmSession().getContainer() == null;
        }
    }
}

