/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.pkg;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aesh.command.option.Argument;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.AbstractPathCompleter;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.state.AbstractFPProvisionedCommand;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.cli.model.PackageInfo;
import org.jboss.galleon.cli.path.FeatureContainerPathConsumer;
import org.jboss.galleon.cli.path.PathConsumerException;
import org.jboss.galleon.cli.path.PathParser;
import org.jboss.galleon.cli.path.PathParserException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.universe.FeaturePackLocation;

public abstract class AbstractPackageCommand
extends AbstractFPProvisionedCommand {
    @Argument(required=true, description="Package name", completer=PackageCompleter.class)
    private String pkg;

    protected String getPackage() {
        return this.pkg;
    }

    @Override
    public FeaturePackLocation.ProducerSpec getProducer(PmSession session) throws CommandExecutionException {
        if (this.pkg == null) {
            throw new CommandExecutionException("No package set.");
        }
        String fullpath = "/packages/" + this.pkg;
        FeatureContainerPathConsumer consumer = new FeatureContainerPathConsumer(new AllPackagesContainer(session.getState().getContainer()), false);
        try {
            PathParser.parse(fullpath, consumer);
            Group grp = consumer.getCurrentNode(fullpath);
            if (grp == null) {
                throw new CommandExecutionException("Invalid package " + this.pkg);
            }
            PackageInfo info = grp.getPackage();
            if (info == null) {
                throw new CommandExecutionException("Invalid package " + this.pkg);
            }
            return info.getFPID().getProducer();
        }
        catch (PathConsumerException | PathParserException ex) {
            throw new CommandExecutionException(session, CliErrors.retrieveProducerFailed(), ex);
        }
    }

    @Override
    public FeaturePackConfig getProvisionedFP(PmSession session) throws CommandExecutionException {
        FeaturePackConfig config = super.getProvisionedFP(session);
        if (config == null) {
            int i = this.getPackage().indexOf("/");
            String orig = this.getPackage().substring(0, i);
            String name = this.getPackage().substring(i + 1);
            FeaturePackLocation.FPID fpid = null;
            for (Map.Entry<String, FeatureContainer> entry : session.getContainer().getFullDependencies().entrySet()) {
                FeatureContainer container = entry.getValue();
                if (!container.getAllPackages().containsKey(Identity.fromString(orig, name))) continue;
                fpid = container.getFPID();
                break;
            }
            if (fpid == null) {
                throw new CommandExecutionException("No package found for " + this.getPackage());
            }
            for (FeaturePackConfig c : session.getState().getConfig().getFeaturePackDeps()) {
                if (!c.getLocation().getFPID().equals(fpid)) continue;
                config = c;
                break;
            }
        }
        if (config == null) {
            throw new CommandExecutionException("No feature pack found for " + this.getPackage());
        }
        return config;
    }

    public static class PackageCompleter
    extends AbstractPathCompleter {
        @Override
        protected FeatureContainer getContainer(PmCompleterInvocation completerInvocation) throws Exception {
            PmSession session = completerInvocation.getPmSession();
            return new AllPackagesContainer(session.getState().getContainer());
        }

        @Override
        protected String getCurrentPath(PmCompleterInvocation session) throws Exception {
            return "/packages/";
        }

        @Override
        protected void filterCandidates(FeatureContainerPathConsumer consumer, List<String> candidates) {
        }
    }

    public static class AllPackagesContainer
    extends FeatureContainer {
        private final FeatureContainer container;

        public AllPackagesContainer(FeatureContainer container) {
            super(null, null, container.getProvisioningConfig());
            this.container = container;
        }

        @Override
        public Map<String, Group> getPackages() {
            HashMap<String, Group> map = new HashMap<String, Group>();
            for (FeatureContainer dep : this.container.getFullDependencies().values()) {
                for (String orig : dep.getPackages().keySet()) {
                    Group root = (Group)map.get(orig);
                    if (root == null) {
                        root = Group.fromString(null, orig);
                        map.put(orig, root);
                    }
                    Group depRoot = dep.getPackages().get(orig);
                    for (Group pkg : depRoot.getGroups()) {
                        root.addGroup(pkg);
                    }
                }
            }
            return map;
        }
    }
}

