/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.config.mvn;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.cli.Util;
import org.jboss.galleon.cli.config.mvn.MavenConfig;
import org.jboss.galleon.cli.config.mvn.MavenRemoteRepository;
import org.jboss.galleon.cli.config.mvn.MavenSettings;

class MavenCliSettings
implements MavenSettings {
    private final List<RemoteRepository> repositories;
    private final RepositorySystemSession session;

    MavenCliSettings(MavenConfig config, RepositorySystem repoSystem, RepositoryListener listener) throws ArtifactException {
        this.repositories = Collections.unmodifiableList(this.buildRepositories(config));
        ProxySelector proxySelector = null;
        this.session = Util.newRepositorySession(repoSystem, config.getLocalRepository(), listener, proxySelector, false);
    }

    @Override
    public List<RemoteRepository> getRepositories() {
        return this.repositories;
    }

    @Override
    public RepositorySystemSession getSession() {
        return this.session;
    }

    private List<RemoteRepository> buildRepositories(MavenConfig config) throws ArtifactException {
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        for (MavenRemoteRepository repo : config.getRemoteRepositories()) {
            RemoteRepository.Builder builder = new RemoteRepository.Builder(repo.getName(), repo.getType(), repo.getUrl());
            builder.setSnapshotPolicy(new RepositoryPolicy(true, "never", "warn"));
            builder.setReleasePolicy(new RepositoryPolicy(true, "never", "warn"));
            repos.add(builder.build());
        }
        return repos;
    }
}

