/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.config.mvn;

import java.io.IOException;
import java.nio.file.Paths;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.config.mvn.MavenConfig;
import org.jboss.galleon.cli.config.mvn.MavenRemoteRepository;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class MavenConfigXml {
    public static final String REPOSITORIES = "repositories";
    public static final String LOCAL_REPOSITORY = "local-repository";
    public static final String SETTINGS = "settings";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String REPOSITORY = "repository";
    public static final String MAVEN = "maven";

    public static void read(XMLExtendedStreamReader reader, MavenConfig config) throws ProvisioningException, XMLStreamException, IOException {
        block14: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "repositories": {
                            MavenConfigXml.readRepositories(reader, config);
                            continue block14;
                        }
                        case "local-repository": {
                            config.setLocalRepository(Paths.get(reader.getElementText(), new String[0]));
                            continue block14;
                        }
                        case "settings": {
                            config.setSettings(Paths.get(reader.getElementText(), new String[0]));
                            continue block14;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
    }

    private static void readRepositories(XMLExtendedStreamReader reader, MavenConfig config) throws ProvisioningException, XMLStreamException, IOException {
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    if (!reader.getLocalName().equals(REPOSITORIES)) continue block10;
                    return;
                }
                case 1: {
                    switch (reader.getLocalName()) {
                        case "repository": {
                            MavenRemoteRepository repo = new MavenRemoteRepository(reader.getAttributeValue(null, NAME), reader.getAttributeValue(null, TYPE), reader.getElementText());
                            config.addRemoteRepository(repo);
                            continue block10;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
    }
}

