/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.universe.FeaturePackLocation;

public class Caches {
    private static final Map<FeaturePackLocation.FPID, FeatureContainer> FP_CACHE = new HashMap<FeaturePackLocation.FPID, FeatureContainer>();
    private static final Map<FeaturePackLocation.FPID, Set<FeatureSpecInfo>> SPEC_CACHE = new HashMap<FeaturePackLocation.FPID, Set<FeatureSpecInfo>>();

    public static FeatureContainer getFeaturePackInfo(FeaturePackLocation.FPID fpid) {
        return FP_CACHE.get(fpid);
    }

    public static Map<FeaturePackLocation.FPID, Set<FeatureSpecInfo>> getSpecs() throws IOException {
        return SPEC_CACHE;
    }

    public static void addFeaturePackInfo(FeaturePackLocation.FPID fpid, FeatureContainer info) {
        FP_CACHE.put(fpid, info);
    }

    public static void addSpecs(Map<FeaturePackLocation.FPID, Set<FeatureSpecInfo>> specs) throws IOException {
        SPEC_CACHE.putAll(specs);
    }
}

