/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model;

import java.util.HashMap;
import java.util.Map;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.cli.model.PackageInfo;
import org.jboss.galleon.spec.PackageDependencySpec;

public class PackageGroupsBuilder {
    private final Map<Identity, Group> allPackagesGroups = new HashMap<Identity, Group>();
    private Group packagesRoot;

    PackageGroupsBuilder() {
        this.resetRoots();
        this.allPackagesGroups.put(this.packagesRoot.getIdentity(), this.packagesRoot);
    }

    final void resetRoots() {
        this.packagesRoot = Group.fromString(null, "###ROOT");
    }

    Group getPackagesRoot() {
        return this.packagesRoot;
    }

    Map<Identity, Group> getPackages() {
        return this.allPackagesGroups;
    }

    void buildGroups(PackageInfo pkg, PackageInfoBuilder builder) {
        this.buildGroups(this.packagesRoot, pkg, builder);
    }

    private void buildGroups(Group grp, PackageInfo pkg, PackageInfoBuilder builder) {
        Group gp = this.allPackagesGroups.get(pkg.getIdentity());
        if (gp == null) {
            gp = Group.fromIdentity(pkg.getIdentity());
            this.allPackagesGroups.put(pkg.getIdentity(), gp);
            gp.setPackage(pkg);
            for (PackageDependencySpec s : pkg.getSpec().getLocalPackageDeps()) {
                this.buildGroups(gp, builder.build(Identity.fromString(s.getName()), pkg), builder);
            }
            for (String o : pkg.getSpec().getPackageOrigins()) {
                for (PackageDependencySpec p : pkg.getSpec().getExternalPackageDeps(o)) {
                    this.buildGroups(gp, builder.build(Identity.fromString(o, p.getName()), pkg), builder);
                }
            }
        }
        grp.addGroup(gp);
    }

    public static interface PackageInfoBuilder {
        public PackageInfo build(Identity var1, PackageInfo var2);
    }
}

