/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.model.state;

import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.universe.UniverseSpec;

public class Provisioning {
    State.Action addUniverse(String name, String factory, String location) {
        return new AddUniverseAction(name, factory, location);
    }

    State.Action removeUniverse(String name) {
        return new RemoveUniverseAction(name);
    }

    private class RemoveUniverseAction
    implements State.Action {
        private final String name;
        private UniverseSpec existing;

        RemoveUniverseAction(String name) {
            this.name = name;
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            this.existing = this.name == null ? current.getDefaultUniverse() : current.getUniverseSpec(this.name);
            if (this.existing == null) {
                throw new ProvisioningException("No default Universe to remove");
            }
            builder.removeUniverse(this.name);
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            if (this.name == null) {
                builder.setDefaultUniverse(this.existing);
            } else {
                builder.addUniverse(this.name, this.existing);
            }
        }
    }

    private class AddUniverseAction
    implements State.Action {
        private final String name;
        private final String factory;
        private final String location;

        AddUniverseAction(String name, String factory, String location) {
            this.name = name;
            this.factory = factory;
            this.location = location;
        }

        @Override
        public void doAction(ProvisioningConfig current, ProvisioningConfig.Builder builder) throws ProvisioningException {
            if (this.name == null) {
                builder.setDefaultUniverse(this.factory, this.location);
            } else {
                builder.addUniverse(this.name, this.factory, this.location);
            }
        }

        @Override
        public void undoAction(ProvisioningConfig.Builder builder) throws ProvisioningException {
            builder.removeUniverse(this.name);
        }
    }
}

