/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.tracking;

import org.aesh.utils.ANSI;
import org.aesh.utils.Config;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.progresstracking.ProgressCallback;
import org.jboss.galleon.progresstracking.ProgressTracker;

abstract class CliProgressTracker<T>
implements ProgressCallback<T> {
    final String msgStart;
    final String msgComplete;
    PmCommandInvocation invocation;

    CliProgressTracker(String msgStart, String msgComplete) {
        this.msgStart = msgStart;
        this.msgComplete = msgComplete;
    }

    void commandStart(PmCommandInvocation invocation) {
        this.invocation = invocation;
    }

    void commandEnd(PmCommandInvocation invocation) {
        this.invocation = invocation;
    }

    void print(String content) {
        this.invocation.getShell().write(ANSI.CURSOR_SAVE);
        this.invocation.getShell().write(ANSI.ERASE_WHOLE_LINE);
        this.invocation.getShell().write(content);
        this.invocation.getShell().write(ANSI.CURSOR_RESTORE);
    }

    @Override
    public void starting(ProgressTracker<T> tracker) {
        this.print(this.msgStart);
    }

    @Override
    public void processing(ProgressTracker<T> tracker) {
        String content = this.processingContent(tracker);
        if (content != null) {
            this.print(this.msgStart + " " + content);
        }
    }

    @Override
    public void pulse(ProgressTracker<T> tracker) {
    }

    @Override
    public void complete(ProgressTracker<T> tracker) {
        if (this.msgComplete != null) {
            String content = this.completeContent(tracker);
            this.print(this.msgComplete + (content == null ? "" : " " + content) + Config.getLineSeparator());
        } else {
            this.invocation.getShell().write(ANSI.ERASE_WHOLE_LINE);
        }
    }

    protected abstract String processingContent(ProgressTracker<T> var1);

    protected abstract String completeContent(ProgressTracker<T> var1);
}

