/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.creator.tasks;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jboss.galleon.creator.tasks.FsTaskContext;
import org.jboss.galleon.creator.tasks.RelativeTargetTask;

class StringToFile
extends RelativeTargetTask {
    private final String content;
    private final boolean isContent;

    protected StringToFile(String content, String relativeTarget) {
        this(relativeTarget, content, true);
    }

    protected StringToFile(String content, String relativeTarget, boolean isContent) {
        super(relativeTarget);
        this.content = content;
        this.isContent = isContent;
    }

    @Override
    public void execute(FsTaskContext ctx) throws IOException {
        Path target = this.resolveTarget(ctx);
        if (!Files.exists(target.getParent(), new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(target, new OpenOption[0]);){
            writer.write(this.content);
        }
    }

    @Override
    public boolean isContent() {
        return this.isContent;
    }
}

