/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.diff;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.diff.FileSystemMerge;
import org.jboss.galleon.diff.ProvisioningDiffResult;
import org.jboss.galleon.util.IoUtils;

public class OursStrategy
extends FileSystemMerge {
    public OursStrategy(MessageWriter messageWriter, Path stagedInstallation, Path customizedInstallation) {
        super(messageWriter, stagedInstallation, customizedInstallation);
    }

    @Override
    public void executeUpdate(ProvisioningDiffResult result) throws IOException {
        for (Path deletedPath : result.getDeletedFiles()) {
            this.messageWriter.verbose("File %s has been removed", this.resolveStagePath(deletedPath));
            IoUtils.recursiveDelete(this.resolveStagePath(deletedPath));
        }
        for (Path addedPath : result.getAddedFiles()) {
            Path target = this.resolveStagePath(addedPath);
            Path src = this.resolveOriginPath(addedPath);
            try {
                if (Files.isDirectory(src, new LinkOption[0])) {
                    Files.createDirectories(target, new FileAttribute[0]);
                } else {
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    Files.copy(src, target, new CopyOption[0]);
                }
                this.messageWriter.verbose("File %s has been copied to %s", src, target);
            }
            catch (IOException ioex) {
                throw new RuntimeException("Couldn't copy file " + src, ioex);
            }
        }
        this.patchFiles(result.getUnifiedDiffs());
    }

    @Override
    public void patchFailure(Path path) {
        Path target = this.resolveStagePath(path);
        Path src = this.resolveOriginPath(path);
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(src, target, StandardCopyOption.REPLACE_EXISTING);
            this.messageWriter.verbose("Because of patch failure: file %s has been copied to %s", src, target);
        }
        catch (IOException ioex) {
            throw new RuntimeException("Couldn't copy file " + src, ioex);
        }
    }
}

