/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.diff;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.creator.FeaturePackBuilder;
import org.jboss.galleon.creator.PackageBuilder;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.xml.FileSystemDiffResultWriter;

public class ProvisioningDiffResult {
    private final Set<Path> deletedFiles;
    private final Set<Path> addedFiles;
    private final Set<Path> modifiedBinaryFiles;
    private final Map<Path, List<String>> unifiedDiffs;
    protected final List<ConfigModel> configs = new ArrayList<ConfigModel>();
    protected final Map<FeaturePackLocation.FPID, ConfigId> includedConfigs = new HashMap<FeaturePackLocation.FPID, ConfigId>();

    public ProvisioningDiffResult(Set<Path> deletedFiles, Set<Path> addedFiles, Set<Path> modifiedBinaryFiles, Map<Path, List<String>> unifiedDiffs) {
        this.deletedFiles = new LinkedHashSet<Path>(deletedFiles);
        this.addedFiles = new LinkedHashSet<Path>(addedFiles);
        this.modifiedBinaryFiles = new LinkedHashSet<Path>(modifiedBinaryFiles);
        this.unifiedDiffs = new LinkedHashMap<Path, List<String>>(unifiedDiffs);
    }

    public Map<FeaturePackLocation.FPID, ConfigId> getIncludedConfigs() {
        return Collections.unmodifiableMap(this.includedConfigs);
    }

    public List<ConfigModel> getConfigs() {
        return Collections.unmodifiableList(this.configs);
    }

    public static ProvisioningDiffResult empty() {
        return new ProvisioningDiffResult(new LinkedHashSet<Path>(0), new LinkedHashSet<Path>(0), new LinkedHashSet<Path>(0), new LinkedHashMap<Path, List<String>>(0));
    }

    public Set<Path> getDeletedFiles() {
        return this.deletedFiles;
    }

    public Set<Path> getAddedFiles() {
        return this.addedFiles;
    }

    public Map<Path, List<String>> getUnifiedDiffs() {
        return this.unifiedDiffs;
    }

    public Set<Path> getModifiedBinaryFiles() {
        return this.modifiedBinaryFiles;
    }

    public ProvisioningDiffResult merge(ProvisioningDiffResult result) {
        this.deletedFiles.addAll(result.getDeletedFiles());
        this.addedFiles.addAll(result.getAddedFiles());
        this.modifiedBinaryFiles.addAll(result.getModifiedBinaryFiles());
        this.unifiedDiffs.putAll(result.getUnifiedDiffs());
        this.includedConfigs.putAll(result.getIncludedConfigs());
        this.configs.addAll(result.getConfigs());
        return this;
    }

    public void toFeaturePack(FeaturePackBuilder fpBuilder, Map<String, FeaturePackConfig.Builder> builders, ProvisioningRuntime runtime, Path installationHome) throws ProvisioningException {
        PackageBuilder addedFilesPackage = fpBuilder.newPackage("added_files").setDefault();
        for (Path src : this.getAddedFiles()) {
            addedFilesPackage.addPath(src.toString(), installationHome.resolve(src));
        }
        PackageBuilder updatedFilesPackage = fpBuilder.newPackage("modified_files").setDefault();
        for (Path src : this.getModifiedBinaryFiles()) {
            updatedFilesPackage.addPath(src.toString(), installationHome.resolve(src));
        }
        for (Path src : this.getUnifiedDiffs().keySet()) {
            updatedFilesPackage.addPath(src.toString(), installationHome.resolve(src));
        }
    }

    public void toXML(Path target, Path customizedInstallation) throws XMLStreamException, IOException {
        FileSystemDiffResultWriter.getInstance().write(this, target.resolve("filesystem_changes.xml"));
        Path addedDir = target.resolve("added_files");
        for (Path addedFile : this.getAddedFiles()) {
            Path newFile = addedDir.resolve(addedFile);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            Files.copy(customizedInstallation.resolve(addedFile), newFile, new CopyOption[0]);
        }
        Path modifiedDir = target.resolve("modified_files");
        for (Path modifiedFile : this.getModifiedBinaryFiles()) {
            Path newFile = modifiedDir.resolve(modifiedFile);
            Files.createDirectories(newFile.getParent(), new FileAttribute[0]);
            Files.copy(customizedInstallation.resolve(modifiedFile), newFile, new CopyOption[0]);
        }
    }
}

