/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.maven.plugin.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.config.ConfigModel;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.maven.plugin.util.ConfigurationId;
import org.jboss.galleon.repomanager.FeaturePackRepositoryManager;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.xml.ConfigXmlParser;

public class FeaturePackInstaller {
    private final Path repoHome;
    private final Path installationDir;
    private final FeaturePackLocation fpl;
    private boolean inheritConfigs = true;
    private List<ConfigurationId> includedConfigs = Collections.emptyList();
    private Path customConfig;
    private boolean inheritPackages = true;
    private List<String> includedPackages = Collections.emptyList();
    private List<String> excludedPackages = Collections.emptyList();
    private Map<String, String> pluginOptions = Collections.emptyMap();

    public static FeaturePackInstaller newInstance(Path repoHome, Path installationDir, ArtifactCoords.Gav fpGav) {
        return new FeaturePackInstaller(repoHome, installationDir, LegacyGalleon1Universe.toFpl(fpGav));
    }

    public static FeaturePackInstaller newInstance(Path repoHome, Path installationDir, FeaturePackLocation fpl) {
        return new FeaturePackInstaller(repoHome, installationDir, fpl);
    }

    private FeaturePackInstaller(Path repoHome, Path installationDir, FeaturePackLocation fpl) {
        this.repoHome = repoHome;
        this.installationDir = installationDir;
        this.fpl = fpl;
    }

    public FeaturePackInstaller setInheritConfigs(boolean inheritConfigs) {
        this.inheritConfigs = inheritConfigs;
        return this;
    }

    public FeaturePackInstaller includeConfig(ConfigurationId configId) {
        this.includedConfigs = CollectionUtils.add(this.includedConfigs, configId);
        return this;
    }

    public FeaturePackInstaller includeConfigs(List<ConfigurationId> configIds) {
        this.includedConfigs = CollectionUtils.addAll(this.includedConfigs, configIds);
        return this;
    }

    public FeaturePackInstaller setCustomConfig(Path customConfig) {
        this.customConfig = customConfig;
        return this;
    }

    public FeaturePackInstaller setInheritPackages(boolean inheritPackages) {
        this.inheritPackages = inheritPackages;
        return this;
    }

    public FeaturePackInstaller includePackage(String packageName) {
        this.includedPackages = CollectionUtils.add(this.includedPackages, packageName);
        return this;
    }

    public FeaturePackInstaller includePackages(List<String> packageNames) {
        this.includedPackages = CollectionUtils.addAll(this.includedPackages, packageNames);
        return this;
    }

    public FeaturePackInstaller excludePackage(String packageName) {
        this.excludedPackages = CollectionUtils.add(this.excludedPackages, packageName);
        return this;
    }

    public FeaturePackInstaller excludePackages(List<String> packageNames) {
        this.excludedPackages = CollectionUtils.addAll(this.excludedPackages, packageNames);
        return this;
    }

    public FeaturePackInstaller setPluginOption(String option) {
        return this.setPluginOption(option, null);
    }

    public FeaturePackInstaller setPluginOption(String option, String value) {
        this.pluginOptions = CollectionUtils.put(this.pluginOptions, option, value);
        return this;
    }

    public FeaturePackInstaller setPluginOptions(Map<String, String> options) {
        this.pluginOptions = CollectionUtils.putAll(this.pluginOptions, options);
        return this;
    }

    public void install() {
        try {
            ProvisioningManager manager = this.getManager();
            System.setProperty("org.wildfly.logging.skipLogManagerCheck", "true");
            ConfigModel config = null;
            if (this.customConfig != null && Files.exists(this.customConfig, new LinkOption[0])) {
                try {
                    BufferedReader reader = Files.newBufferedReader(this.customConfig);
                    Iterator<String> iterator = null;
                    try {
                        config = ConfigXmlParser.getInstance().parse(reader);
                    }
                    catch (Throwable throwable) {
                        iterator = throwable;
                        throw throwable;
                    }
                    finally {
                        if (reader != null) {
                            if (iterator != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable) {
                                    ((Throwable)((Object)iterator)).addSuppressed(throwable);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                catch (IOException | XMLStreamException ex) {
                    throw new IllegalArgumentException("Couldn't load the customization configuration " + this.customConfig, ex);
                }
            }
            FeaturePackConfig.Builder fpConfigBuilder = (FeaturePackConfig.Builder)FeaturePackConfig.builder(this.fpl).setInheritPackages(this.inheritPackages).setInheritConfigs(this.inheritConfigs);
            if (this.includedConfigs != null && !this.includedConfigs.isEmpty()) {
                for (ConfigurationId configId : this.includedConfigs) {
                    if (configId.isModelOnly()) {
                        fpConfigBuilder.includeConfigModel(configId.getId().getModel());
                        continue;
                    }
                    fpConfigBuilder.includeDefaultConfig(configId.getId());
                }
            }
            if (config != null) {
                fpConfigBuilder.addConfig(config);
            }
            if (this.includedPackages != null && !this.includedPackages.isEmpty()) {
                for (String includedPackage : this.includedPackages) {
                    fpConfigBuilder.includePackage(includedPackage);
                }
            }
            if (this.excludedPackages != null && !this.excludedPackages.isEmpty()) {
                for (String excludedPackage : this.excludedPackages) {
                    fpConfigBuilder.excludePackage(excludedPackage);
                }
            }
            manager.install(fpConfigBuilder.build(), this.pluginOptions);
        }
        catch (ProvisioningException ex) {
            throw new IllegalArgumentException("Couldn't install feature-pack " + this.fpl, ex);
        }
        finally {
            System.clearProperty("org.wildfly.logging.skipLogManagerCheck");
        }
    }

    private ProvisioningManager getManager() throws ProvisioningException {
        return ((ProvisioningManager.Builder)ProvisioningManager.builder().addArtifactResolver(FeaturePackRepositoryManager.newInstance(this.repoHome))).setInstallationHome(this.installationDir).build();
    }
}

