/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.repomanager;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.ArtifactException;
import org.jboss.galleon.ArtifactRepositoryManager;
import org.jboss.galleon.util.ZipUtils;

public class FeaturePackRepositoryManager
implements ArtifactRepositoryManager {
    final Path repoHome;

    public static FeaturePackRepositoryManager newInstance(Path repoHome) {
        return new FeaturePackRepositoryManager(repoHome);
    }

    private FeaturePackRepositoryManager(Path repoHome) {
        this.repoHome = repoHome;
    }

    @Override
    public void install(ArtifactCoords coords, Path artifact) throws ArtifactException {
        try {
            Path path = this.getArtifactPath(coords);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (Files.isDirectory(artifact, new LinkOption[0])) {
                ZipUtils.zip(artifact, path);
            } else {
                Files.copy(artifact, path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(FeaturePackRepositoryManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void deploy(ArtifactCoords coords, Path artifact) throws ArtifactException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Path resolve(ArtifactCoords coords) throws ArtifactException {
        Path path = this.getArtifactPath(coords);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new ArtifactException("Artifact " + coords + " not found in the repository at " + path);
        }
        return path;
    }

    private Path getArtifactPath(ArtifactCoords coords) {
        String[] groupParts;
        Path p = this.repoHome;
        for (String part : groupParts = coords.getGroupId().split("\\.")) {
            p = p.resolve(part);
        }
        p = p.resolve(coords.getArtifactId());
        p = p.resolve(coords.getVersion());
        StringBuilder fileName = new StringBuilder();
        fileName.append(coords.getArtifactId()).append('-').append(coords.getVersion());
        String classifier = coords.getClassifier();
        if (classifier != null && !classifier.isEmpty()) {
            fileName.append('-').append(classifier);
        }
        fileName.append('.').append(coords.getExtension());
        return p.resolve(fileName.toString());
    }

    @Override
    public String getHighestVersion(ArtifactCoords coords, String range) throws ArtifactException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

