/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.config.ConfigCustomizations;
import org.jboss.galleon.config.ConfigId;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.PackageConfig;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.CollectionUtils;

class FpStack {
    private static final int INHERIT_PKGS_FALSE = -1;
    private static final int INHERIT_PKGS_NOT_FOUND = 0;
    private static final int INHERIT_PKGS_TRANSITIVE = 1;
    private static final int INHERIT_PKGS_TRUE = 2;
    private final ProvisioningConfig config;
    private List<Level> levels = new ArrayList<Level>();
    private Level lastPushed;
    private List<List<Level>> recordedStacks = Collections.emptyList();

    FpStack(ProvisioningConfig config) {
        this.config = config;
    }

    boolean push(FeaturePackConfig fpConfig, boolean extendCurrentLevel) {
        if (!this.isRelevant(fpConfig)) {
            return false;
        }
        if (extendCurrentLevel) {
            this.lastPushed.addFpConfig(fpConfig);
            return true;
        }
        Level newLevel = new Level();
        newLevel.addFpConfig(fpConfig);
        this.levels.add(newLevel);
        this.lastPushed = newLevel;
        return true;
    }

    void popLevel() {
        if (this.isEmpty()) {
            return;
        }
        if (this.levels.size() == 1) {
            this.levels.clear();
            this.lastPushed = null;
        } else {
            this.levels.remove(this.levels.size() - 1);
            this.lastPushed = this.levels.get(this.levels.size() - 1);
        }
    }

    boolean isEmpty() {
        return this.lastPushed == null;
    }

    boolean hasNext() {
        if (this.lastPushed == null) {
            return false;
        }
        return this.lastPushed.hasNext();
    }

    FeaturePackConfig next() {
        if (this.lastPushed == null) {
            throw new NoSuchElementException();
        }
        return this.lastPushed.next();
    }

    boolean isFilteredOut(FeaturePackLocation.ProducerSpec producer, ConfigId configId, boolean fromPrevLevel) {
        int i = this.levels.size() - (fromPrevLevel ? 2 : 1);
        while (i >= 0) {
            if (!this.levels.get(i--).isFilteredOut(producer, configId)) continue;
            return true;
        }
        return FpStack.isFilteredOut(this.config, configId);
    }

    private static boolean isFilteredOut(ConfigCustomizations configCustoms, ConfigId configId) {
        if (configId.isAnonymous()) {
            return !configCustoms.isInheritConfigs();
        }
        if (configId.isModelOnly()) {
            return configCustoms.isConfigModelExcluded(configId) || !configCustoms.isInheritModelOnlyConfigs();
        }
        if (configCustoms.isInheritConfigs()) {
            if (configCustoms.isConfigExcluded(configId)) {
                return true;
            }
            if (configCustoms.isConfigModelExcluded(configId)) {
                return !configCustoms.isConfigIncluded(configId);
            }
            return false;
        }
        if (configCustoms.isConfigIncluded(configId)) {
            return false;
        }
        if (configCustoms.isConfigModelIncluded(configId)) {
            return configCustoms.isConfigExcluded(configId);
        }
        return true;
    }

    private boolean isRelevant(FeaturePackConfig fpConfig) {
        if (this.isEmpty()) {
            return true;
        }
        FeaturePackLocation.ProducerSpec producer = fpConfig.getLocation().getProducer();
        int inheritPkgs = this.isInheritPackages(producer);
        if (inheritPkgs == 0 || inheritPkgs == 1 && !fpConfig.isTransitive()) {
            return true;
        }
        if (inheritPkgs > 0) {
            if (fpConfig.hasExcludedPackages()) {
                for (String excluded : fpConfig.getExcludedPackages()) {
                    if (this.isPackageExcluded(producer, excluded) || this.isPackageIncluded(producer, excluded)) continue;
                    return true;
                }
            }
            if (fpConfig.hasIncludedPackages()) {
                for (PackageConfig included : fpConfig.getIncludedPackages()) {
                    if (this.isPackageIncluded(producer, included.getName()) || this.isPackageExcluded(producer, included.getName())) continue;
                    return true;
                }
            }
        }
        if (fpConfig.hasDefinedConfigs()) {
            boolean configsInherited = true;
            for (int i = this.levels.size() - 1; i >= 0; --i) {
                if (this.levels.get(i).isInheritConfigs()) continue;
                configsInherited = false;
                break;
            }
            if (configsInherited) {
                return true;
            }
        }
        if (fpConfig.hasModelOnlyConfigs()) {
            boolean configsInherited = true;
            for (int i = this.levels.size() - 1; i >= 0; --i) {
                if (this.levels.get(i).isInheritModelOnlyConfigs()) continue;
                configsInherited = false;
                break;
            }
            if (configsInherited) {
                return true;
            }
        }
        return false;
    }

    private int isInheritPackages(FeaturePackLocation.ProducerSpec producer) {
        int result = 0;
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            int levelResult = this.levels.get(i).isInheritPackages(producer);
            if (levelResult < 0) {
                return levelResult;
            }
            if (levelResult <= result) continue;
            result = levelResult;
        }
        return result;
    }

    boolean isPackageExcluded(FeaturePackLocation.ProducerSpec producer, String packageName) {
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            if (!this.levels.get(i).isPackageExcluded(producer, packageName)) continue;
            return true;
        }
        return false;
    }

    private boolean isPackageIncluded(FeaturePackLocation.ProducerSpec producer, String packageName) {
        for (int i = this.levels.size() - 1; i >= 0; --i) {
            if (!this.levels.get(i).isPackageIncluded(producer, packageName)) continue;
            return true;
        }
        return false;
    }

    boolean isPackageFilteredOut(FeaturePackLocation.ProducerSpec producer, String packageName, boolean fromPrevLevel) {
        Level level;
        Boolean filteredOut;
        int i = this.levels.size() - (fromPrevLevel ? 2 : 1);
        if (i < 0) {
            return false;
        }
        if ((filteredOut = (level = this.levels.get(i--)).isPackageFilteredOut(producer, packageName)) != null && filteredOut.booleanValue()) {
            return true;
        }
        while (i >= 0) {
            level = this.levels.get(i--);
            if (filteredOut == null && !level.isInheritPackages()) {
                return true;
            }
            filteredOut = level.isPackageFilteredOut(producer, packageName);
            if (filteredOut == null || !filteredOut.booleanValue()) continue;
            return true;
        }
        return filteredOut == null && !level.isInheritPackages();
    }

    void recordStack() {
        ArrayList<Level> copy = new ArrayList<Level>(this.levels.size());
        for (int i = 0; i < this.levels.size(); ++i) {
            copy.add(this.levels.get(i).copy());
        }
        this.recordedStacks = CollectionUtils.add(this.recordedStacks, copy);
    }

    void activateConfigStack(int i) throws ProvisioningException {
        if (this.recordedStacks.size() <= i) {
            throw new ProvisioningException("Stack index " + i + " is exceeding the current stack size " + this.recordedStacks.size());
        }
        this.levels = this.recordedStacks.get(i);
        this.lastPushed = this.levels.isEmpty() ? null : this.levels.get(this.levels.size() - 1);
    }

    private class Level {
        private List<FeaturePackConfig> fpConfigs = Collections.emptyList();
        private Map<FeaturePackLocation.ProducerSpec, FeaturePackConfig> transitive = Collections.emptyMap();
        private int currentFp = -1;

        private Level() {
        }

        Level copy() {
            Level copy = new Level();
            copy.fpConfigs = CollectionUtils.clone(this.fpConfigs);
            copy.currentFp = this.currentFp;
            return copy;
        }

        void addFpConfig(FeaturePackConfig fpConfig) {
            this.fpConfigs = CollectionUtils.add(this.fpConfigs, fpConfig);
            if (fpConfig.isTransitive()) {
                this.transitive = CollectionUtils.put(this.transitive, fpConfig.getLocation().getProducer(), fpConfig);
            }
        }

        boolean hasNext() {
            return this.currentFp + 1 < this.fpConfigs.size();
        }

        FeaturePackConfig next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException(this.currentFp + 1 + " exceeded " + this.fpConfigs.size());
            }
            return this.fpConfigs.get(++this.currentFp);
        }

        boolean isFilteredOut(FeaturePackLocation.ProducerSpec producer, ConfigId configId) {
            FeaturePackConfig fpConfig = this.transitive.get(producer);
            if (fpConfig != null && FpStack.isFilteredOut(fpConfig, configId)) {
                return true;
            }
            return FpStack.isFilteredOut(this.fpConfigs.get(this.currentFp), configId);
        }

        boolean isInheritConfigs() {
            return this.fpConfigs.get(this.currentFp).isInheritConfigs();
        }

        boolean isInheritModelOnlyConfigs() {
            return this.fpConfigs.get(this.currentFp).isInheritModelOnlyConfigs();
        }

        boolean isInheritPackages() {
            return this.fpConfigs.get(this.currentFp).isInheritPackages();
        }

        int isInheritPackages(FeaturePackLocation.ProducerSpec producer) {
            FeaturePackConfig fpConfig = this.getFpConfig(producer);
            if (fpConfig == null) {
                return 0;
            }
            if (!fpConfig.isInheritPackages()) {
                return -1;
            }
            return fpConfig.isTransitive() ? 1 : 2;
        }

        boolean isPackageExcluded(FeaturePackLocation.ProducerSpec producer, String packageName) {
            FeaturePackConfig fpConfig = this.getFpConfig(producer);
            return fpConfig == null ? false : fpConfig.isPackageExcluded(packageName);
        }

        boolean isPackageIncluded(FeaturePackLocation.ProducerSpec producer, String packageName) {
            FeaturePackConfig fpConfig = this.getFpConfig(producer);
            return fpConfig == null ? false : fpConfig.isPackageIncluded(packageName);
        }

        Boolean isPackageFilteredOut(FeaturePackLocation.ProducerSpec producer, String packageName) {
            FeaturePackConfig fpConfig = this.getFpConfig(producer);
            if (fpConfig == null) {
                return null;
            }
            if (fpConfig.isInheritPackages()) {
                return fpConfig.isPackageExcluded(packageName);
            }
            return !fpConfig.isPackageIncluded(packageName);
        }

        private FeaturePackConfig getFpConfig(FeaturePackLocation.ProducerSpec producer) {
            for (int i = this.fpConfigs.size() - 1; i >= 0; --i) {
                FeaturePackConfig fpConfig = this.fpConfigs.get(i);
                if (!fpConfig.getLocation().getProducer().equals(producer)) continue;
                return fpConfig;
            }
            return null;
        }
    }
}

