/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.diff.ProvisioningDiffResult;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.FileSystemDiffResultParser;
import org.jboss.galleon.xml.PlugableXmlParser;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class FileSystemDiffResultParser10
implements PlugableXmlParser<ProvisioningDiffResult> {
    @Override
    public QName getRoot() {
        return FileSystemDiffResultParser.ROOT_1_0;
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, ProvisioningDiffResult fileSystemDiffResult) throws XMLStreamException {
        block10: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    FileSystemDiffResultParser.Element element = FileSystemDiffResultParser.Element.of(reader.getName());
                    switch (element) {
                        case ADDED: {
                            this.readAddedFiles(reader, fileSystemDiffResult);
                            continue block10;
                        }
                        case DELETED: {
                            this.readDeletedFiles(reader, fileSystemDiffResult);
                            continue block10;
                        }
                        case MODIFIED: {
                            this.readModifiedBinaryedFiles(reader, fileSystemDiffResult);
                            continue block10;
                        }
                        case CHANGES: {
                            this.readChanges(reader, fileSystemDiffResult);
                            continue block10;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void readAddedFiles(XMLExtendedStreamReader reader, ProvisioningDiffResult fileSystemDiffResult) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    FileSystemDiffResultParser.Element element = FileSystemDiffResultParser.Element.of(reader.getName());
                    switch (element) {
                        case PATH: {
                            fileSystemDiffResult.getAddedFiles().add(new File(reader.getElementText()).toPath());
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void readDeletedFiles(XMLExtendedStreamReader reader, ProvisioningDiffResult fileSystemDiffResult) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    FileSystemDiffResultParser.Element element = FileSystemDiffResultParser.Element.of(reader.getName());
                    switch (element) {
                        case PATH: {
                            fileSystemDiffResult.getDeletedFiles().add(new File(reader.getElementText()).toPath());
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void readModifiedBinaryedFiles(XMLExtendedStreamReader reader, ProvisioningDiffResult fileSystemDiffResult) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    FileSystemDiffResultParser.Element element = FileSystemDiffResultParser.Element.of(reader.getName());
                    switch (element) {
                        case PATH: {
                            fileSystemDiffResult.getModifiedBinaryFiles().add(new File(reader.getElementText()).toPath());
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void readChanges(XMLExtendedStreamReader reader, ProvisioningDiffResult fileSystemDiffResult) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    FileSystemDiffResultParser.Element element = FileSystemDiffResultParser.Element.of(reader.getName());
                    switch (element) {
                        case CHANGE: {
                            Path path = new File(reader.getAttributeValue(0)).toPath();
                            if (fileSystemDiffResult.getUnifiedDiffs().containsKey(path)) {
                                fileSystemDiffResult.getUnifiedDiffs().get(path).add(reader.getElementText());
                                continue block7;
                            }
                            ArrayList<String> diff = new ArrayList<String>();
                            diff.add(reader.getElementText());
                            fileSystemDiffResult.getUnifiedDiffs().put(path, diff);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }
}

