/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.jboss.galleon.ArtifactCoords;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.runtime.ResolvedFeatureId;
import org.jboss.galleon.runtime.ResolvedSpecId;
import org.jboss.galleon.state.ProvisionedConfig;
import org.jboss.galleon.state.ProvisionedFeaturePack;
import org.jboss.galleon.state.ProvisionedPackage;
import org.jboss.galleon.state.ProvisionedState;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.galleon1.LegacyGalleon1Universe;
import org.jboss.galleon.util.ParsingUtils;
import org.jboss.galleon.xml.PlugableXmlParser;
import org.jboss.galleon.xml.ProvisionedConfigBuilder;
import org.jboss.galleon.xml.ProvisionedFeatureBuilder;
import org.jboss.galleon.xml.XmlNameProvider;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class ProvisionedStateXmlParser10
implements PlugableXmlParser<ProvisionedState.Builder> {
    public static final String NAMESPACE_1_0 = "urn:jboss:galleon:provisioned-state:1.0";
    public static final QName ROOT_1_0 = new QName("urn:jboss:galleon:provisioned-state:1.0", Element.INSTALLATION.getLocalName());

    ProvisionedStateXmlParser10() {
    }

    @Override
    public QName getRoot() {
        return ROOT_1_0;
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, ProvisionedState.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block8: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FEATURE_PACK: {
                            builder.addFeaturePack(this.readFeaturePack(reader));
                            continue block8;
                        }
                        case CONFIG: {
                            builder.addConfig(ProvisionedStateXmlParser10.readConfig(reader));
                            continue block8;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private ProvisionedFeaturePack readFeaturePack(XMLExtendedStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String groupId = null;
        String artifactId = null;
        String version = null;
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case GROUP_ID: {
                    groupId = reader.getAttributeValue(i);
                    continue block12;
                }
                case ARTIFACT_ID: {
                    artifactId = reader.getAttributeValue(i);
                    continue block12;
                }
                case VERSION: {
                    version = reader.getAttributeValue(i);
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (groupId == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.GROUP_ID));
        }
        if (artifactId == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.ARTIFACT_ID));
        }
        if (version == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.VERSION));
        }
        ProvisionedFeaturePack.Builder fpBuilder = ProvisionedFeaturePack.builder(LegacyGalleon1Universe.toFpl(ArtifactCoords.newGav(groupId, artifactId, version)).getFPID());
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return fpBuilder.build();
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PACKAGES: {
                            this.readPackageList(reader, fpBuilder);
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void readPackageList(XMLExtendedStreamReader reader, ProvisionedFeaturePack.Builder builder) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PACKAGE: {
                            builder.addPackage(this.readPackage(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private ProvisionedPackage readPackage(XMLExtendedStreamReader reader) throws XMLStreamException {
        String name = null;
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        ParsingUtils.parseNoContent(reader);
        return ProvisionedPackage.newInstance(name);
    }

    private static ProvisionedConfig readConfig(XMLExtendedStreamReader reader) throws XMLStreamException {
        ProvisionedConfigBuilder config = ProvisionedConfigBuilder.builder();
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    config.setName(reader.getAttributeValue(i));
                    continue block12;
                }
                case MODEL: {
                    config.setModel(reader.getAttributeValue(i));
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return config.build();
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PROPS: {
                            ProvisionedStateXmlParser10.readProps(reader, config);
                            continue block13;
                        }
                        case FEATURE_PACK: {
                            ProvisionedStateXmlParser10.readFeaturePack(reader, config);
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readProps(XMLExtendedStreamReader reader, ProvisionedConfigBuilder config) throws XMLStreamException {
        ParsingUtils.parseNoAttributes(reader);
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PROP: {
                            ProvisionedStateXmlParser10.readProp(reader, config);
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readProp(XMLExtendedStreamReader reader, ProvisionedConfigBuilder config) throws XMLStreamException {
        String name = null;
        String value = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (name == null) {
            if (value == null) {
                HashSet<Attribute> attrs = new HashSet<Attribute>();
                attrs.add(Attribute.NAME);
                attrs.add(Attribute.VALUE);
                throw ParsingUtils.missingAttributes(reader.getLocation(), attrs);
            }
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        if (value == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.VALUE));
        }
        config.setProperty(name, value);
        ParsingUtils.parseNoContent(reader);
    }

    private static void readFeaturePack(XMLExtendedStreamReader reader, ProvisionedConfigBuilder config) throws XMLStreamException {
        String group = null;
        String artifact = null;
        String version = null;
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case GROUP_ID: {
                    group = reader.getAttributeValue(i);
                    continue block12;
                }
                case ARTIFACT_ID: {
                    artifact = reader.getAttributeValue(i);
                    continue block12;
                }
                case VERSION: {
                    version = reader.getAttributeValue(i);
                    continue block12;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        HashSet<Attribute> missingAttrs = null;
        if (group == null) {
            missingAttrs = new HashSet<Attribute>();
            missingAttrs.add(Attribute.GROUP_ID);
        }
        if (artifact == null) {
            if (missingAttrs == null) {
                missingAttrs = new HashSet();
            }
            missingAttrs.add(Attribute.ARTIFACT_ID);
        }
        if (version == null) {
            if (missingAttrs == null) {
                missingAttrs = new HashSet();
            }
            missingAttrs.add(Attribute.VERSION);
        }
        if (missingAttrs != null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), missingAttrs);
        }
        block13: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case SPEC: {
                            ProvisionedStateXmlParser10.readSpec(reader, LegacyGalleon1Universe.newFPID(group, artifact, version).getProducer(), config);
                            continue block13;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readSpec(XMLExtendedStreamReader reader, FeaturePackLocation.ProducerSpec producer, ProvisionedConfigBuilder config) throws XMLStreamException {
        String name = null;
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block10;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (name == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.NAME));
        }
        ResolvedSpecId specId = new ResolvedSpecId(producer, name);
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case FEATURE: {
                            ProvisionedStateXmlParser10.readFeature(reader, specId, config);
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readFeature(XMLExtendedStreamReader reader, ResolvedSpecId specId, ProvisionedConfigBuilder config) throws XMLStreamException {
        ProvisionedFeatureBuilder featureBuilder;
        ResolvedFeatureId id = null;
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case ID: {
                    try {
                        id = ResolvedFeatureId.fromGalleon1String(reader.getAttributeValue(i));
                        continue block14;
                    }
                    catch (ProvisioningDescriptionException e) {
                        throw new XMLStreamException(Errors.parseXml(), e);
                    }
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        ProvisionedFeatureBuilder provisionedFeatureBuilder = featureBuilder = id == null ? ProvisionedFeatureBuilder.builder(specId) : ProvisionedFeatureBuilder.builder(id);
        block15: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    try {
                        config.addFeature(featureBuilder.build());
                    }
                    catch (ProvisioningDescriptionException e) {
                        throw new XMLStreamException("Failed to instantiate provisioned feature", reader.getLocation(), e);
                    }
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case PARAM: {
                            ProvisionedStateXmlParser10.readParam(reader, featureBuilder);
                            continue block15;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private static void readParam(XMLExtendedStreamReader reader, ProvisionedFeatureBuilder featureBuilder) throws XMLStreamException {
        String name = null;
        String value = null;
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block4;
                }
                case VALUE: {
                    value = reader.getAttributeValue(i);
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (name == null) {
            Set<Attribute> missingAttrs = null;
            if (value == null) {
                missingAttrs = new HashSet<Attribute>(2);
                missingAttrs.add(Attribute.NAME);
                missingAttrs.add(Attribute.VALUE);
            } else {
                missingAttrs = Collections.singleton(Attribute.NAME);
            }
            throw ParsingUtils.missingAttributes(reader.getLocation(), missingAttrs);
        }
        if (value == null) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), Collections.singleton(Attribute.VALUE));
        }
        featureBuilder.setConfigParam(name, value);
        ParsingUtils.parseNoContent(reader);
    }

    static enum Attribute implements XmlNameProvider
    {
        ARTIFACT_ID("artifactId"),
        GROUP_ID("groupId"),
        ID("id"),
        MODEL("model"),
        NAME("name"),
        VALUE("value"),
        VERSION("version"),
        UNKNOWN(null);

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return null;
        }

        public String toString() {
            return this.name;
        }

        static {
            attributes = new HashMap<QName, Attribute>(8);
            attributes.put(new QName(Attribute.ARTIFACT_ID.name), ARTIFACT_ID);
            attributes.put(new QName(Attribute.GROUP_ID.name), GROUP_ID);
            attributes.put(new QName(Attribute.ID.name), ID);
            attributes.put(new QName(Attribute.MODEL.name), MODEL);
            attributes.put(new QName(Attribute.NAME.name), NAME);
            attributes.put(new QName(Attribute.VALUE.name), VALUE);
            attributes.put(new QName(Attribute.VERSION.name), VERSION);
            attributes.put(null, UNKNOWN);
        }
    }

    static enum Element implements XmlNameProvider
    {
        CONFIG("config"),
        FEATURE("feature"),
        FEATURE_PACK("feature-pack"),
        INSTALLATION("installation"),
        PACKAGE("package"),
        PACKAGES("packages"),
        PARAM("param"),
        PROP("prop"),
        PROPS("props"),
        SPEC("spec"),
        UNKNOWN(null);

        private static final Map<QName, Element> elements;
        private final String name;
        private final String namespace = "urn:jboss:galleon:provisioned-state:1.0";

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(ProvisionedStateXmlParser10.NAMESPACE_1_0, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        @Override
        public String getLocalName() {
            return this.name;
        }

        @Override
        public String getNamespace() {
            return ProvisionedStateXmlParser10.NAMESPACE_1_0;
        }

        public String toString() {
            return this.name;
        }

        static {
            elements = new HashMap<QName, Element>(11);
            elements.put(new QName(ProvisionedStateXmlParser10.NAMESPACE_1_0, Element.CONFIG.name), CONFIG);
            elements.put(new QName(ProvisionedStateXmlParser10.NAMESPACE_1_0, Element.FEATURE.name), FEATURE);
            elements.put(new QName(ProvisionedStateXmlParser10.NAMESPACE_1_0, Element.FEATURE_PACK.name), FEATURE_PACK);
            elements.put(new QName(ProvisionedStateXmlParser10.NAMESPACE_1_0, Element.INSTALLATION.name), INSTALLATION);
            elements.put(new QName(ProvisionedStateXmlParser10.NAMESPACE_1_0, Element.PACKAGE.name), PACKAGE);
            elements.put(new QName(ProvisionedStateXmlParser10.NAMESPACE_1_0, Element.PACKAGES.name), PACKAGES);
            elements.put(new QName(ProvisionedStateXmlParser10.NAMESPACE_1_0, Element.PARAM.name), PARAM);
            elements.put(new QName(ProvisionedStateXmlParser10.NAMESPACE_1_0, Element.PROP.name), PROP);
            elements.put(new QName(ProvisionedStateXmlParser10.NAMESPACE_1_0, Element.PROPS.name), PROPS);
            elements.put(new QName(ProvisionedStateXmlParser10.NAMESPACE_1_0, Element.SPEC.name), SPEC);
            elements.put(null, UNKNOWN);
        }
    }
}

