/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.plugin;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.AbstractDynamicCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.FPLocationCompleter;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.universe.FeaturePackLocation;

public abstract class AbstractPluginsCommand
extends AbstractDynamicCommand {
    public AbstractPluginsCommand(PmSession pmSession) {
        super(pmSession, true, true);
    }

    protected boolean isVerbose() {
        return this.contains("verbose");
    }

    @Override
    protected void runCommand(PmCommandInvocation session, Map<String, String> options) throws CommandExecutionException {
        if (this.isVerbose()) {
            session.getPmSession().enableMavenTrace(true);
        }
        try {
            String id = this.getId(this.pmSession);
            FeaturePackLocation loc = id == null ? null : this.pmSession.getResolvedLocation(id);
            this.runCommand(session, options, loc);
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.resolveLocationFailed(), ex);
        }
        finally {
            session.getPmSession().enableMavenTrace(false);
        }
    }

    protected abstract void runCommand(PmCommandInvocation var1, Map<String, String> var2, FeaturePackLocation var3) throws CommandExecutionException;

    protected OptionActivator getArgumentActivator() {
        return null;
    }

    @Override
    protected void doValidateOptions(PmCommandInvocation invoc) throws CommandExecutionException {
        String fpl = this.getId(this.pmSession);
        if (fpl == null) {
            throw new CommandExecutionException("Missing feature-pack");
        }
    }

    @Override
    protected List<ProcessedOption> getStaticOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        options.add(ProcessedOptionBuilder.builder().name("org.jboss.pm.tool.arg").hasValue(true).description("FP Location").type(String.class).required(true).optionType(OptionType.ARGUMENT).activator(this.getArgumentActivator()).completer(FPLocationCompleter.class).build());
        options.add(ProcessedOptionBuilder.builder().name("verbose").hasValue(false).type(Boolean.class).description("Whether or not the output should be verbose").optionType(OptionType.BOOLEAN).build());
        options.addAll(this.getOtherOptions());
        return options;
    }

    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        return Collections.emptyList();
    }

    @Override
    protected List<AbstractDynamicCommand.DynamicOption> getDynamicOptions(State state, String id) throws Exception {
        ArrayList<AbstractDynamicCommand.DynamicOption> options = new ArrayList<AbstractDynamicCommand.DynamicOption>();
        FeaturePackLocation fpl = this.pmSession.getResolvedLocation(id);
        Set<PluginOption> pluginOptions = this.getPluginOptions(fpl);
        for (PluginOption opt : pluginOptions) {
            AbstractDynamicCommand.DynamicOption dynOption = new AbstractDynamicCommand.DynamicOption(this, opt.getName(), opt.isRequired(), opt.isAcceptsValue());
            options.add(dynOption);
        }
        return options;
    }

    protected abstract Set<PluginOption> getPluginOptions(FeaturePackLocation var1) throws ProvisioningException;

    protected abstract Path getInstallationHome(AeshContext var1);

    protected ProvisioningManager getManager(PmCommandInvocation session) throws ProvisioningException {
        return session.getPmSession().newProvisioningManager(this.getInstallationHome(session.getAeshContext()), this.isVerbose());
    }

    @Override
    protected String getId(PmSession session) throws CommandExecutionException {
        String streamName = (String)this.getValue("org.jboss.pm.tool.arg");
        if (streamName == null) {
            streamName = this.getArgumentValue();
        }
        if (streamName != null) {
            try {
                return session.getResolvedLocation(streamName).toString();
            }
            catch (ProvisioningException provisioningException) {
                // empty catch block
            }
        }
        return null;
    }
}

