/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aesh.command.CommandDefinition;
import org.aesh.command.activator.OptionActivator;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.internal.ParsedOption;
import org.aesh.command.option.Option;
import org.aesh.utils.Config;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.state.StateCommandActivator;
import org.jboss.galleon.cli.cmd.state.pkg.AbstractPackageCommand;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.cli.model.FeatureInfo;
import org.jboss.galleon.cli.model.FeatureSpecInfo;
import org.jboss.galleon.cli.model.Group;
import org.jboss.galleon.cli.model.Identity;
import org.jboss.galleon.cli.model.PackageInfo;
import org.jboss.galleon.cli.path.FeatureContainerPathConsumer;
import org.jboss.galleon.cli.path.PathConsumerException;
import org.jboss.galleon.cli.path.PathParser;
import org.jboss.galleon.cli.path.PathParserException;
import org.jboss.galleon.runtime.ResolvedSpecId;

@CommandDefinition(name="search", description="search the state for the provided content", activator=StateCommandActivator.class)
public class SearchCommand
extends PmSessionCommand {
    @Option(required=false, activator=QueryActivator.class)
    private String query;
    @Option(required=false, name="package", completer=AbstractPackageCommand.PackageCompleter.class, activator=PackageActivator.class)
    private String pkg;
    @Option(required=false, name="include-dependencies", hasValue=false)
    private Boolean inDependencies;

    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        try {
            if (this.query == null && this.pkg == null) {
                throw new CommandExecutionException("One of --query or --package must be set");
            }
            FeatureContainer container = invoc.getPmSession().getContainer();
            this.run(invoc.getPmSession().getContainer(), invoc, false);
            if (this.inDependencies.booleanValue() && !container.getFullDependencies().isEmpty()) {
                invoc.println("");
                invoc.println("Search in dependencies");
                for (FeatureContainer c : container.getFullDependencies().values()) {
                    invoc.println("dependency: " + c.getFPID());
                    this.run(c, invoc, true);
                }
            }
        }
        catch (Exception ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.searchFailed(), ex);
        }
    }

    private void run(FeatureContainer container, PmCommandInvocation invoc, boolean dependencySearch) throws PathParserException, PathConsumerException, ProvisioningException {
        if (this.pkg != null) {
            PackageInfo spec = this.getPackage(dependencySearch ? container : new AbstractPackageCommand.AllPackagesContainer(container), this.pkg);
            invoc.println(Config.getLineSeparator() + "As a direct dependency of a package:");
            StringBuilder pBuilder = new StringBuilder();
            for (Map.Entry<String, Group> entry : container.getPackages().entrySet()) {
                Group root2 = entry.getValue();
                block1: for (Group group : root2.getGroups()) {
                    for (Group group2 : group.getGroups()) {
                        if (!group2.getIdentity().equals(spec.getIdentity())) continue;
                        pBuilder.append("  " + group.getIdentity()).append(Config.getLineSeparator());
                        continue block1;
                    }
                }
            }
            if (pBuilder.length() != 0) {
                invoc.println(pBuilder.toString());
            } else {
                invoc.println("NONE");
            }
            Set<ResolvedSpecId> set = this.findFeatures(spec, container);
            invoc.println("Reachable from features:");
            if (set.isEmpty()) {
                invoc.println("NONE");
            } else {
                for (ResolvedSpecId id : set) {
                    List<FeatureInfo> features = container.getAllFeatures().get(id);
                    if (features != null) {
                        for (FeatureInfo fi : features) {
                            invoc.println("  " + fi.getPath());
                        }
                        continue;
                    }
                    invoc.println("      [spec only] " + this.toPath(id));
                }
            }
            return;
        }
        invoc.println(Config.getLineSeparator() + "Packages:");
        StringBuilder pBuilder = new StringBuilder();
        for (Map.Entry<String, Group> entry : container.getPackages().entrySet()) {
            Group group = entry.getValue();
            for (Group g : group.getGroups()) {
                PackageInfo packageInfo = g.getPackage();
                if (!packageInfo.getIdentity().toString().contains(this.query)) continue;
                pBuilder.append("  /packages/" + packageInfo.getIdentity()).append(Config.getLineSeparator());
                if (dependencySearch) continue;
                pBuilder.append("    Reachable from features:").append(Config.getLineSeparator());
                Set<ResolvedSpecId> fspecs = this.findFeatures(packageInfo, container);
                if (fspecs.isEmpty()) {
                    pBuilder.append("      NONE" + Config.getLineSeparator());
                }
                Iterator iterator = fspecs.iterator();
                while (iterator.hasNext()) {
                    ResolvedSpecId id = (ResolvedSpecId)iterator.next();
                    List<FeatureInfo> features = container.getAllFeatures().get(id);
                    if (features != null) {
                        for (FeatureInfo fi : features) {
                            pBuilder.append("      " + fi.getPath()).append(Config.getLineSeparator());
                        }
                        continue;
                    }
                    pBuilder.append("  [spec only] " + this.toPath(id)).append(Config.getLineSeparator());
                }
            }
        }
        if (pBuilder.length() != 0) {
            invoc.println(pBuilder.toString());
        } else {
            invoc.println("NONE");
        }
        pBuilder = new StringBuilder();
        invoc.println(Config.getLineSeparator() + "Package dependencies:");
        for (Map.Entry<String, Group> entry : container.getPackages().entrySet()) {
            Group group = entry.getValue();
            for (Group g : group.getGroups()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Group group3 : g.getGroups()) {
                    if (!group3.getIdentity().toString().contains(this.query)) continue;
                    stringBuilder.append("  " + group3.getIdentity()).append(Config.getLineSeparator());
                    break;
                }
                if (stringBuilder.length() == 0) continue;
                pBuilder.append("  Found as a direct dependencies of " + g.getIdentity()).append(Config.getLineSeparator());
                pBuilder.append((CharSequence)stringBuilder);
            }
        }
        if (pBuilder.length() != 0) {
            invoc.println(pBuilder.toString());
        } else {
            invoc.println("NONE");
        }
        pBuilder = new StringBuilder();
        invoc.println(Config.getLineSeparator() + "Package content:");
        for (Map.Entry<String, Group> entry : container.getPackages().entrySet()) {
            Group group = entry.getValue();
            for (Group g : group.getGroups()) {
                PackageInfo packageInfo = g.getPackage();
                StringBuilder contentBuilder = new StringBuilder();
                for (String c : packageInfo.getContent()) {
                    if (!c.contains(this.query)) continue;
                    contentBuilder.append(c).append(Config.getLineSeparator());
                }
                if (contentBuilder.length() == 0) continue;
                pBuilder.append("  Found in content of " + g.getIdentity()).append(Config.getLineSeparator());
                pBuilder.append((CharSequence)contentBuilder);
            }
        }
        if (pBuilder.length() != 0) {
            invoc.println(pBuilder.toString());
        } else {
            invoc.println("NONE");
        }
        pBuilder = new StringBuilder();
        invoc.println(Config.getLineSeparator() + "Features:");
        for (Map.Entry<Object, Object> entry : container.getAllFeatures().entrySet()) {
            ResolvedSpecId resolvedSpecId = (ResolvedSpecId)entry.getKey();
            List fs = (List)entry.getValue();
            if (fs == null) {
                if (!resolvedSpecId.getName().contains(this.query)) continue;
                pBuilder.append("  [spec only] " + this.toPath(resolvedSpecId)).append(Config.getLineSeparator());
                continue;
            }
            for (FeatureInfo featureInfo : fs) {
                if (!featureInfo.getPath().contains(this.query)) continue;
                pBuilder.append("  " + featureInfo.getPath()).append(Config.getLineSeparator());
            }
        }
        if (pBuilder.length() != 0) {
            invoc.println(pBuilder.toString());
        } else {
            invoc.println("NONE");
        }
    }

    private String toPath(ResolvedSpecId id) {
        return "/feature-specs/" + Identity.buildOrigin(id.getProducer()) + '/' + id.getName().replaceAll("\\.", "/");
    }

    private Set<ResolvedSpecId> findFeatures(PackageInfo spec, FeatureContainer container) {
        HashSet<ResolvedSpecId> fspecs = new HashSet<ResolvedSpecId>();
        block0: for (Map.Entry<ResolvedSpecId, FeatureSpecInfo> features : container.getAllSpecs().entrySet()) {
            for (PackageInfo info : features.getValue().getPackages()) {
                Group grp = container.getAllPackages().get(info.getIdentity());
                HashSet<Identity> identities = new HashSet<Identity>();
                this.visitPkg(grp, identities);
                if (!identities.contains(spec.getIdentity())) continue;
                fspecs.add(features.getKey());
                continue block0;
            }
        }
        return fspecs;
    }

    private PackageInfo getPackage(FeatureContainer container, String id) throws PathParserException, PathConsumerException, ProvisioningException {
        String path = "/packages/" + id;
        FeatureContainerPathConsumer consumer = new FeatureContainerPathConsumer(container, false);
        PathParser.parse(path, consumer);
        Group grp = consumer.getCurrentNode(path);
        if (grp == null) {
            throw new ProvisioningException("Invalid path");
        }
        if (grp.getPackage() == null) {
            throw new ProvisioningException("Path is not a package");
        }
        return grp.getPackage();
    }

    private void visitPkg(Group pkg, Set<Identity> identities) {
        if (!identities.contains(pkg.getIdentity())) {
            identities.add(pkg.getIdentity());
            for (Group dep : pkg.getGroups()) {
                this.visitPkg(dep, identities);
            }
        }
    }

    public static class PackageActivator
    implements OptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck("query");
            return opt == null || opt.value() == null;
        }
    }

    public static class QueryActivator
    implements OptionActivator {
        @Override
        public boolean isActivated(ParsedCommand parsedCommand) {
            ParsedOption opt = parsedCommand.findLongOptionNoActivatorCheck("package");
            return opt == null || opt.value() == null;
        }
    }
}

