/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.nio.file.Path;
import org.aesh.command.CommandDefinition;
import org.jboss.galleon.cli.AbstractStateCommand;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.state.NoStateCommandActivator;
import org.jboss.galleon.cli.model.FeatureContainer;

@CommandDefinition(name="explore", description="Explore an installation", activator=NoStateCommandActivator.class)
public class StateExploreCommand
extends AbstractStateCommand {
    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        Path install;
        PmSession pm = session.getPmSession();
        try {
            if (pm.getContainer() != null) {
                throw new CommandExecutionException("Already entered, use leave command");
            }
            FeatureContainer container = this.getFeatureContainer(pm, null);
            pm.setExploredContainer(container);
            install = this.getInstallationDirectory(session.getAeshContext());
            pm.setCurrentPath("/");
        }
        catch (Exception ex) {
            if (ex instanceof CommandExecutionException) {
                throw (CommandExecutionException)ex;
            }
            throw new CommandExecutionException(session.getPmSession(), CliErrors.exploreFailed(), ex);
        }
        session.setPrompt(PmSession.buildPrompt("/"));
        session.println("Exploring " + install.getFileName() + ". Use 'state leave' to leave exploration.");
    }
}

