/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.universe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.AbstractCompleter;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.CliErrors;

@CommandDefinition(name="remove", description="remove a universe, without --name, removes the default universe")
public class UniverseRemoveCommand
extends PmSessionCommand {
    @Option(completer=UniverseCompleter.class, required=false)
    private String name;

    @Override
    protected void runCommand(PmCommandInvocation commandInvocation) throws CommandExecutionException {
        try {
            commandInvocation.getPmSession().getUniverse().removeUniverse(this.name);
        }
        catch (IOException | ProvisioningException ex) {
            throw new CommandExecutionException(commandInvocation.getPmSession(), CliErrors.removeUniverseFailed(), ex);
        }
    }

    public static class UniverseCompleter
    extends AbstractCompleter {
        @Override
        protected List<String> getItems(PmCompleterInvocation completerInvocation) {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(completerInvocation.getPmSession().getUniverse().getUniverseNames());
            return names;
        }
    }
}

