/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.resolver;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.resolver.ResolutionException;

public class ResourceResolver {
    private final Map<String, CompletableFuture<?>> content = new HashMap();
    private static final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thr = new Thread(r, "Galleon CLI resource resolver");
            thr.setDaemon(true);
            return thr;
        }
    });
    private final PmSession pmSession;

    public ResourceResolver(PmSession pmSession) {
        this.pmSession = pmSession;
    }

    public <T> void resolve(String key, Resolver<T> res) {
        this.doResolve(key, res, true);
    }

    public <T> void resolveSync(String key, Resolver<T> res) {
        this.doResolve(key, res, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> CompletableFuture<T> doResolve(String key, Resolver<T> res, boolean async) {
        CompletableFuture<Object> comp;
        ResourceResolver resourceResolver = this;
        synchronized (resourceResolver) {
            comp = this.content.get(key);
            if (comp == null) {
                comp = new CompletableFuture();
                this.content.put(key, comp);
            }
        }
        CompletableFuture<Object> finalComp = comp;
        if (async) {
            executorService.submit(() -> this.resolve(key, finalComp, res));
        } else {
            this.resolve(key, finalComp, res);
        }
        return comp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void resolve(String key, CompletableFuture<T> finalComp, Resolver<T> res) {
        T t;
        try {
            t = res.resolve();
        }
        catch (Throwable thr) {
            Logger.getLogger(ResourceResolver.class.getName()).log(Level.FINEST, "Exception while resolving: {0}", thr.getLocalizedMessage());
            ResourceResolver resourceResolver = this;
            synchronized (resourceResolver) {
                this.content.remove(key);
                finalComp.completeExceptionally(thr);
                return;
            }
        }
        finalComp.complete(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(String key, Resolver<T> res) throws InterruptedException, ExecutionException {
        CompletableFuture<Object> comp;
        if (key == null) {
            CompletableFuture comp2 = new CompletableFuture();
            this.resolve(key, comp2, res);
            return comp2.get();
        }
        ResourceResolver resourceResolver = this;
        synchronized (resourceResolver) {
            comp = this.content.get(key);
            if (comp == null && res != null) {
                comp = this.doResolve(key, res, false);
            }
        }
        if (comp != null) {
            Object ret = comp.get();
            return (T)ret;
        }
        return null;
    }

    public static interface Resolver<T> {
        public T resolve() throws ResolutionException;
    }
}

