/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.ConfigItem;
import org.jboss.galleon.config.ConfigItemContainer;
import org.jboss.galleon.config.FeatureConfig;
import org.jboss.galleon.config.FeatureGroup;
import org.jboss.galleon.config.FeatureGroupBuilderSupport;
import org.jboss.galleon.spec.FeatureId;
import org.jboss.galleon.spec.PackageDepsSpec;
import org.jboss.galleon.spec.SpecId;
import org.jboss.galleon.util.CollectionUtils;

public abstract class FeatureGroupSupport
extends PackageDepsSpec
implements ConfigItem,
ConfigItemContainer {
    final String origin;
    final String name;
    final boolean inheritFeatures;
    final Set<SpecId> includedSpecs;
    final Map<FeatureId, FeatureConfig> includedFeatures;
    final Set<SpecId> excludedSpecs;
    final Map<FeatureId, String> excludedFeatures;
    final Map<String, FeatureGroup> externalFgConfigs;
    protected final List<ConfigItem> items;

    protected FeatureGroupSupport(String origin, String name) {
        this.origin = origin;
        this.name = name;
        this.inheritFeatures = true;
        this.includedSpecs = Collections.emptySet();
        this.includedFeatures = Collections.emptyMap();
        this.excludedSpecs = Collections.emptySet();
        this.excludedFeatures = Collections.emptyMap();
        this.externalFgConfigs = Collections.emptyMap();
        this.items = Collections.emptyList();
    }

    protected FeatureGroupSupport(FeatureGroupBuilderSupport<?> builder) throws ProvisioningDescriptionException {
        super(builder);
        this.origin = builder.origin;
        this.name = builder.name;
        this.inheritFeatures = builder.inheritFeatures;
        this.includedSpecs = CollectionUtils.unmodifiable(builder.includedSpecs);
        this.excludedSpecs = CollectionUtils.unmodifiable(builder.excludedSpecs);
        this.includedFeatures = CollectionUtils.unmodifiable(builder.includedFeatures);
        this.excludedFeatures = CollectionUtils.unmodifiable(builder.excludedFeatures);
        if (builder.externalFgConfigs.isEmpty()) {
            this.externalFgConfigs = Collections.emptyMap();
        } else if (builder.externalFgConfigs.size() == 1) {
            Map.Entry<String, FeatureGroup.Builder> entry = builder.externalFgConfigs.entrySet().iterator().next();
            this.externalFgConfigs = Collections.singletonMap(entry.getKey(), entry.getValue().build());
        } else {
            LinkedHashMap<String, FeatureGroup> tmp = new LinkedHashMap<String, FeatureGroup>(builder.externalFgConfigs.size());
            for (Map.Entry<String, FeatureGroup.Builder> entry : builder.externalFgConfigs.entrySet()) {
                tmp.put(entry.getKey(), entry.getValue().build());
            }
            this.externalFgConfigs = Collections.unmodifiableMap(tmp);
        }
        this.items = CollectionUtils.unmodifiable(builder.items);
    }

    public Object getId() {
        return this.name;
    }

    public boolean isConfig() {
        return false;
    }

    @Override
    public String getOrigin() {
        return this.origin;
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasProperties() {
        return false;
    }

    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    public boolean isInheritFeatures() {
        return this.inheritFeatures;
    }

    public boolean hasExcludedSpecs() {
        return !this.excludedSpecs.isEmpty();
    }

    public Set<SpecId> getExcludedSpecs() {
        return this.excludedSpecs;
    }

    public boolean hasIncludedSpecs() {
        return !this.includedSpecs.isEmpty();
    }

    public Set<SpecId> getIncludedSpecs() {
        return this.includedSpecs;
    }

    public boolean hasExcludedFeatures() {
        return !this.excludedFeatures.isEmpty();
    }

    public Map<FeatureId, String> getExcludedFeatures() {
        return this.excludedFeatures;
    }

    public boolean hasIncludedFeatures() {
        return !this.includedFeatures.isEmpty();
    }

    public Map<FeatureId, FeatureConfig> getIncludedFeatures() {
        return this.includedFeatures;
    }

    public boolean hasExternalFeatureGroups() {
        return !this.externalFgConfigs.isEmpty();
    }

    public Map<String, FeatureGroup> getExternalFeatureGroups() {
        return this.externalFgConfigs;
    }

    @Override
    public boolean hasItems() {
        return !this.items.isEmpty();
    }

    @Override
    public List<ConfigItem> getItems() {
        return this.items;
    }

    @Override
    public boolean isResetFeaturePackOrigin() {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.excludedFeatures == null ? 0 : this.excludedFeatures.hashCode());
        result = 31 * result + (this.excludedSpecs == null ? 0 : this.excludedSpecs.hashCode());
        result = 31 * result + (this.externalFgConfigs == null ? 0 : this.externalFgConfigs.hashCode());
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + (this.includedFeatures == null ? 0 : this.includedFeatures.hashCode());
        result = 31 * result + (this.includedSpecs == null ? 0 : this.includedSpecs.hashCode());
        result = 31 * result + (this.inheritFeatures ? 1231 : 1237);
        result = 31 * result + (this.items == null ? 0 : this.items.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FeatureGroupSupport other = (FeatureGroupSupport)obj;
        if (this.excludedFeatures == null ? other.excludedFeatures != null : !this.excludedFeatures.equals(other.excludedFeatures)) {
            return false;
        }
        if (this.excludedSpecs == null ? other.excludedSpecs != null : !this.excludedSpecs.equals(other.excludedSpecs)) {
            return false;
        }
        if (this.externalFgConfigs == null ? other.externalFgConfigs != null : !this.externalFgConfigs.equals(other.externalFgConfigs)) {
            return false;
        }
        if (this.origin == null ? other.origin != null : !this.origin.equals(other.origin)) {
            return false;
        }
        if (this.includedFeatures == null ? other.includedFeatures != null : !this.includedFeatures.equals(other.includedFeatures)) {
            return false;
        }
        if (this.includedSpecs == null ? other.includedSpecs != null : !this.includedSpecs.equals(other.includedSpecs)) {
            return false;
        }
        if (this.inheritFeatures != other.inheritFeatures) {
            return false;
        }
        if (this.items == null ? other.items != null : !this.items.equals(other.items)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

