/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.layout;

import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.spec.FeaturePackSpec;
import org.jboss.galleon.spec.FeatureSpec;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.xml.FeatureSpecXmlParser;

public interface FeaturePackLayout {
    public static final int DIRECT_DEP = 0;
    public static final int TRANSITIVE_DEP = 1;
    public static final int PATCH = 2;

    public FeaturePackLocation.FPID getFPID();

    public FeaturePackSpec getSpec();

    public Path getDir();

    public int getType();

    default public boolean isDirectDep() {
        return this.getType() == 0;
    }

    default public boolean isTransitiveDep() {
        return this.getType() == 1;
    }

    default public boolean isPatch() {
        return this.getType() == 2;
    }

    default public Path getResource(String ... path) throws ProvisioningDescriptionException {
        if (path.length == 0) {
            throw new IllegalArgumentException("Resource path is null");
        }
        if (path.length == 1) {
            return this.getDir().resolve("resources").resolve(path[0]);
        }
        Path p = this.getDir().resolve("resources");
        for (String name : path) {
            p = p.resolve(name);
        }
        return p;
    }

    default public boolean hasFeatureSpec(String name) {
        return Files.exists(this.getDir().resolve("features").resolve(name).resolve("spec.xml"), new LinkOption[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public FeatureSpec loadFeatureSpec(String name) throws ProvisioningException {
        Path specXml = this.getDir().resolve("features").resolve(name).resolve("spec.xml");
        if (!Files.exists(specXml, new LinkOption[0])) {
            return null;
        }
        try (BufferedReader reader = Files.newBufferedReader(specXml);){
            FeatureSpec featureSpec = FeatureSpecXmlParser.getInstance().parse(reader);
            return featureSpec;
        }
        catch (Exception e) {
            throw new ProvisioningDescriptionException(Errors.parseXml(specXml), e);
        }
    }
}

