/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.universe.maven;

import java.nio.file.Path;
import java.util.Collection;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.Channel;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.LatestVersionNotAvailableException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenChannelDescription;
import org.jboss.galleon.universe.maven.MavenLatestVersionNotAvailableException;
import org.jboss.galleon.universe.maven.MavenProducerBase;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.jboss.galleon.util.StringUtils;

public class MavenChannel
implements Channel,
MavenChannelDescription {
    private final String name;
    private final String versionRange;
    private final MavenProducerBase producer;

    public MavenChannel(MavenProducerBase producer, String name, String versionRange) throws MavenUniverseException {
        assert (name != null) : "Producer name is missing";
        assert (versionRange != null) : "Producer version-range is missing";
        this.name = name;
        this.versionRange = versionRange;
        this.producer = producer;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLatestBuild(FeaturePackLocation fpl) throws ProvisioningException {
        MavenArtifact artifact = new MavenArtifact();
        artifact.setGroupId(this.producer.getFeaturePackGroupId());
        artifact.setArtifactId(this.producer.getFeaturePackArtifactId());
        artifact.setExtension("zip");
        artifact.setVersionRange(this.versionRange);
        try {
            return this.producer.getRepo().getLatestVersion(artifact, this.getFrequency(fpl));
        }
        catch (MavenLatestVersionNotAvailableException e) {
            if (fpl.getFrequency() == null && this.producer.hasDefaultFrequency()) {
                fpl = new FeaturePackLocation(fpl.getUniverse(), fpl.getProducerName(), fpl.getChannelName(), this.producer.getDefaultFrequency(), null);
            }
            throw new LatestVersionNotAvailableException(fpl);
        }
        catch (MavenUniverseException e) {
            throw e;
        }
    }

    @Override
    public Path resolve(FeaturePackLocation fpl) throws MavenUniverseException {
        MavenArtifact artifact = new MavenArtifact();
        artifact.setGroupId(this.producer.getFeaturePackGroupId());
        artifact.setArtifactId(this.producer.getFeaturePackArtifactId());
        artifact.setExtension("zip");
        if (fpl.getBuild() == null) {
            artifact.setVersionRange(this.versionRange);
            this.producer.getRepo().resolveLatestVersion(artifact, this.getFrequency(fpl));
        } else {
            artifact.setVersion(fpl.getBuild());
            this.producer.getRepo().resolve(artifact);
        }
        return artifact.getPath();
    }

    public String getFeaturePackGroupId() {
        return this.producer.getFeaturePackGroupId();
    }

    public String getFeaturePackArtifactId() {
        return this.producer.getFeaturePackArtifactId();
    }

    public Collection<String> getFrequencies() {
        return this.producer.getFrequencies();
    }

    @Override
    public String getVersionRange() {
        return this.versionRange;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getFeaturePackArtifactId().hashCode();
        result = 31 * result + this.getFeaturePackGroupId().hashCode();
        result = 31 * result + this.getFrequencies().hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.versionRange == null ? 0 : this.versionRange.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenChannel other = (MavenChannel)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.versionRange == null ? other.versionRange != null : !this.versionRange.equals(other.versionRange)) {
            return false;
        }
        if (!this.getFeaturePackArtifactId().equals(other.getFeaturePackArtifactId())) {
            return false;
        }
        if (!this.getFeaturePackGroupId().equals(other.getFeaturePackGroupId())) {
            return false;
        }
        return this.getFrequencies().equals(other.getFrequencies());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[channel ").append(this.name);
        buf.append(" groupId=").append(this.getFeaturePackGroupId());
        buf.append(" artifactId=").append(this.getFeaturePackArtifactId());
        buf.append(" version-range=").append(this.versionRange);
        buf.append(" frequencies=");
        StringUtils.append(buf, this.getFrequencies());
        return buf.toString();
    }

    private String getFrequency(FeaturePackLocation fpl) throws MavenUniverseException {
        String frequency = fpl.getFrequency();
        if (frequency == null) {
            return this.producer.getDefaultFrequency();
        }
        if (!this.producer.getFrequencies().contains(frequency)) {
            throw new MavenUniverseException(Errors.frequencyNotSupported(this.producer.getFrequencies(), fpl));
        }
        return frequency;
    }

    @Override
    public boolean isResolved(FeaturePackLocation fpl) throws ProvisioningException {
        MavenArtifact artifact = new MavenArtifact();
        artifact.setGroupId(this.producer.getFeaturePackGroupId());
        artifact.setArtifactId(this.producer.getFeaturePackArtifactId());
        artifact.setExtension("zip");
        if (fpl.getBuild() == null) {
            artifact.setVersionRange(this.versionRange);
            return this.producer.getRepo().isLatestVersionResolved(artifact, this.getFrequency(fpl));
        }
        artifact.setVersion(fpl.getBuild());
        return this.producer.getRepo().isResolved(artifact);
    }

    @Override
    public String getLatestBuild(FeaturePackLocation.FPID fpid) throws ProvisioningException {
        MavenArtifact artifact = new MavenArtifact();
        artifact.setGroupId(this.producer.getFeaturePackGroupId());
        artifact.setArtifactId(this.producer.getFeaturePackArtifactId());
        artifact.setExtension("zip");
        artifact.setVersionRange(this.versionRange);
        try {
            return this.producer.getRepo().getLatestVersion(artifact);
        }
        catch (MavenLatestVersionNotAvailableException e) {
            throw new LatestVersionNotAvailableException(fpid.getLocation());
        }
        catch (MavenUniverseException e) {
            throw e;
        }
    }
}

