/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.aesh.command.Command;
import org.aesh.command.CommandNotFoundException;
import org.aesh.command.activator.CommandActivator;
import org.aesh.command.impl.internal.ParsedCommand;
import org.aesh.command.impl.parser.CommandLineParser;
import org.aesh.command.invocation.CommandInvocation;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.shell.Shell;
import org.aesh.utils.Config;
import org.jboss.galleon.cli.Arguments;
import org.jboss.galleon.cli.CliMain;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.ToolModes;
import org.jboss.galleon.cli.cmd.CommandDomain;

public class HelpSupport {
    private static final String AVAILABLE_COMMANDS = "$AVAILABLE_COMMANDS";
    private static final String AVAILABLE_OPTIONS = "$AVAILABLE_OPTIONS";
    private static final String TAB = "    ";

    public static String getToolHelp(PmSession session, CommandRegistry<? extends Command, ? extends CommandInvocation> registry, Shell shell) throws IOException {
        String staticContent = HelpSupport.getHelp(HelpSupport.getHelpPath("help.txt"));
        String availableOptions = HelpSupport.format(Arguments.getToolOptions(), shell.size().getWidth());
        String availableCommands = HelpSupport.formatDomains(HelpSupport.getAllModesCommandDomains(session, registry), shell);
        staticContent = staticContent.replace(AVAILABLE_OPTIONS, availableOptions);
        staticContent = staticContent.replace(AVAILABLE_COMMANDS, availableCommands);
        return staticContent;
    }

    public static String getHelpCommandHelp(CommandRegistry<? extends Command, ? extends CommandInvocation> registry, Shell shell) throws IOException {
        String staticContent = HelpSupport.getHelp(HelpSupport.getHelpPath("help-command.txt"));
        TreeMap<CommandDomain, HelpCommandDomain> domains = new TreeMap<CommandDomain, HelpCommandDomain>();
        HelpSupport.addCommandDomains(registry, true, true, domains);
        String availableCommands = HelpSupport.formatDomains(domains.values(), shell);
        staticContent = staticContent.replace(AVAILABLE_COMMANDS, availableCommands);
        return staticContent;
    }

    private static String formatDomains(Collection<HelpCommandDomain> domains, Shell shell) {
        StringBuilder commands = new StringBuilder();
        for (HelpCommandDomain domain : domains) {
            commands.append(Config.getLineSeparator()).append(domain.domain.getDescription()).append(Config.getLineSeparator());
            commands.append(HelpSupport.format(domain.commands, shell.size().getWidth()));
        }
        return commands.toString();
    }

    private static String format(Map<String, String> options, int width) {
        int max = 0;
        ArrayList<String> keys = new ArrayList<String>();
        for (String k : options.keySet()) {
            if (k.length() > max) {
                max = k.length();
            }
            keys.add(k);
        }
        Collections.sort(keys);
        StringBuilder builder = new StringBuilder();
        builder.append(Config.getLineSeparator());
        int remaining = width - max - TAB.length();
        String maxPad = HelpSupport.pad(max + TAB.length(), "");
        for (String k : keys) {
            String val = options.get(k);
            builder.append(HelpSupport.pad(max, k)).append(TAB);
            if (val.length() <= remaining) {
                builder.append(val).append(Config.getLineSeparator());
                continue;
            }
            String pad = "";
            do {
                int i;
                int limit = Math.min(remaining, val.length());
                String content = val.substring(0, limit);
                val = val.substring(limit);
                String toNextLine = null;
                if (!val.isEmpty() && (i = content.lastIndexOf(" ")) >= 0) {
                    toNextLine = content.substring(++i);
                    content = content.substring(0, i);
                    val = toNextLine + val;
                }
                builder.append(pad).append(content).append(Config.getLineSeparator());
                pad = maxPad;
            } while (val.length() > 0);
        }
        return builder.toString();
    }

    private static String pad(int max, String k) {
        StringBuilder builder = new StringBuilder();
        builder.append(k);
        for (int i = k.length(); i < max; ++i) {
            builder.append(" ");
        }
        return builder.toString();
    }

    public static List<String> getAvailableCommands(CommandRegistry<? extends Command, ? extends CommandInvocation> registry, boolean includeChilds, boolean onlyEnabled) {
        ArrayList<String> lst = new ArrayList<String>();
        for (String c : registry.getAllCommandNames()) {
            CommandLineParser<? extends Command> cmdParser;
            try {
                cmdParser = registry.getCommand(c, null).getParser();
            }
            catch (CommandNotFoundException ex) {
                continue;
            }
            CommandActivator activator = cmdParser.getProcessedCommand().getActivator();
            if (activator != null && !activator.isActivated(new ParsedCommand(cmdParser.getProcessedCommand()))) continue;
            if (cmdParser.isGroupCommand() && includeChilds) {
                for (CommandLineParser<? extends Command> child : cmdParser.getAllChildParsers()) {
                    CommandActivator childActivator = child.getProcessedCommand().getActivator();
                    if (onlyEnabled && childActivator != null && !childActivator.isActivated(new ParsedCommand(child.getProcessedCommand()))) continue;
                    lst.add(c + " " + child.getProcessedCommand().name());
                }
                continue;
            }
            lst.add(c);
        }
        return lst;
    }

    private static String getHelp(String path) throws IOException {
        InputStream helpInput = CliMain.class.getResourceAsStream(path);
        if (helpInput != null) {
            Throwable throwable = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(helpInput, StandardCharsets.UTF_8));){
                StringBuilder builder = new StringBuilder();
                String helpLine = reader.readLine();
                while (helpLine != null) {
                    builder.append(helpLine).append(Config.getLineSeparator());
                    helpLine = reader.readLine();
                }
                String string = builder.toString();
                return string;
            }
            catch (IOException e) {
                String string = "Failed to read " + path + ". " + e.getLocalizedMessage();
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        return "Failed to locate help description " + path;
    }

    private static String getHelpPath(String file) {
        return "/help/" + file;
    }

    private static Collection<HelpCommandDomain> getAllModesCommandDomains(PmSession session, CommandRegistry<? extends Command, ? extends CommandInvocation> registry) {
        TreeMap<CommandDomain, HelpCommandDomain> domains = new TreeMap<CommandDomain, HelpCommandDomain>();
        session.getToolModes().setMode(ToolModes.Mode.NOMINAL);
        HelpSupport.addCommandDomains(registry, true, false, domains);
        session.getToolModes().setMode(ToolModes.Mode.EDIT);
        HelpSupport.addCommandDomains(registry, true, false, domains);
        return domains.values();
    }

    private static void addCommandDomains(CommandRegistry<? extends Command, ? extends CommandInvocation> registry, boolean includeChild, boolean onlyEnabled, Map<CommandDomain, HelpCommandDomain> domains) {
        for (String c : registry.getAllCommandNames()) {
            CommandLineParser<? extends Command> cmdParser;
            try {
                cmdParser = registry.getCommand(c, null).getParser();
            }
            catch (CommandNotFoundException ex) {
                continue;
            }
            CommandActivator activator = cmdParser.getProcessedCommand().getActivator();
            if (onlyEnabled && activator != null && !activator.isActivated(new ParsedCommand(cmdParser.getProcessedCommand()))) continue;
            CommandDomain domain = CommandDomain.getDomain(cmdParser.getCommand());
            HelpCommandDomain helpDomain = domains.get(domain);
            if (helpDomain == null) {
                helpDomain = new HelpCommandDomain(domain);
                domains.put(domain, helpDomain);
            }
            if (includeChild && cmdParser.isGroupCommand()) {
                for (CommandLineParser<? extends Command> child : cmdParser.getAllChildParsers()) {
                    CommandActivator childActivator = child.getProcessedCommand().getActivator();
                    if (onlyEnabled && childActivator != null && !childActivator.isActivated(new ParsedCommand(child.getProcessedCommand()))) continue;
                    helpDomain.commands.put(c + " " + child.getProcessedCommand().name(), HelpSupport.removeNL(child.getProcessedCommand().description()));
                }
                continue;
            }
            helpDomain.commands.put(c, HelpSupport.removeNL(cmdParser.getProcessedCommand().description()));
        }
    }

    private static String removeNL(String str) {
        return str.replaceAll("\\R", " ");
    }

    private static class HelpCommandDomain {
        private final CommandDomain domain;
        Map<String, String> commands = new TreeMap<String, String>();

        HelpCommandDomain(CommandDomain domain) {
            this.domain = domain;
        }
    }
}

