/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.aesh.command.container.CommandContainer;
import org.aesh.command.impl.container.AeshCommandContainerBuilder;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.registry.MutableCommandRegistry;
import org.aesh.extensions.clear.Clear;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.HelpCommand;
import org.jboss.galleon.cli.cmd.PmExitCommand;
import org.jboss.galleon.cli.cmd.featurepack.FeaturePackCommand;
import org.jboss.galleon.cli.cmd.filesystem.FileSystemCommand;
import org.jboss.galleon.cli.cmd.installation.InstallationCommand;
import org.jboss.galleon.cli.cmd.maingrp.CheckUpdatesCommand;
import org.jboss.galleon.cli.cmd.maingrp.FindCommand;
import org.jboss.galleon.cli.cmd.maingrp.GetInfoCommand;
import org.jboss.galleon.cli.cmd.maingrp.InstallCommand;
import org.jboss.galleon.cli.cmd.maingrp.ListFeaturePacksCommand;
import org.jboss.galleon.cli.cmd.maingrp.ProvisionCommand;
import org.jboss.galleon.cli.cmd.maingrp.UndoCommand;
import org.jboss.galleon.cli.cmd.maingrp.UninstallCommand;
import org.jboss.galleon.cli.cmd.maingrp.UpdateCommand;
import org.jboss.galleon.cli.cmd.mvn.MavenCommand;
import org.jboss.galleon.cli.cmd.state.StateAddUniverseCommand;
import org.jboss.galleon.cli.cmd.state.StateCdCommand;
import org.jboss.galleon.cli.cmd.state.StateCommand;
import org.jboss.galleon.cli.cmd.state.StateExportCommand;
import org.jboss.galleon.cli.cmd.state.StateGetInfoCommand;
import org.jboss.galleon.cli.cmd.state.StateLeaveCommand;
import org.jboss.galleon.cli.cmd.state.StateLsCommand;
import org.jboss.galleon.cli.cmd.state.StateProvisionCommand;
import org.jboss.galleon.cli.cmd.state.StatePwdCommand;
import org.jboss.galleon.cli.cmd.state.StateRemoveUniverseCommand;
import org.jboss.galleon.cli.cmd.state.StateSearchCommand;
import org.jboss.galleon.cli.cmd.state.StateUndoCommand;
import org.jboss.galleon.cli.cmd.state.configuration.StateExcludeConfigCommand;
import org.jboss.galleon.cli.cmd.state.configuration.StateIncludeConfigCommand;
import org.jboss.galleon.cli.cmd.state.configuration.StateRemoveExcludedConfigCommand;
import org.jboss.galleon.cli.cmd.state.configuration.StateRemoveIncludedConfigCommand;
import org.jboss.galleon.cli.cmd.state.configuration.StateResetConfigCommand;
import org.jboss.galleon.cli.cmd.state.feature.StateAddFeatureCommand;
import org.jboss.galleon.cli.cmd.state.feature.StateRemoveFeatureCommand;
import org.jboss.galleon.cli.cmd.state.fp.StateAddFeaturePackCommand;
import org.jboss.galleon.cli.cmd.state.fp.StateRemoveFeaturePackCommand;
import org.jboss.galleon.cli.cmd.state.pkg.StateExcludePackageCommand;
import org.jboss.galleon.cli.cmd.state.pkg.StateIncludePackageCommand;
import org.jboss.galleon.cli.cmd.state.pkg.StateRemoveExcludedPackageCommand;
import org.jboss.galleon.cli.cmd.state.pkg.StateRemoveIncludedPackageCommand;

public class ToolModes {
    private final MutableCommandRegistry registry;
    private final List<CommandContainer> nominalCommands = new ArrayList<CommandContainer>();
    private final List<CommandContainer> commonCommands = new ArrayList<CommandContainer>();
    private final List<CommandContainer> editCommands = new ArrayList<CommandContainer>();
    private final AeshCommandContainerBuilder containerBuilder = new AeshCommandContainerBuilder();
    private Mode activeMode;

    private ToolModes(PmSession pmSession, MutableCommandRegistry registry) throws CommandLineParserException {
        this.registry = registry;
        HelpCommand help = new HelpCommand();
        help.setRegistry(registry);
        this.commonCommands.add(this.containerBuilder.create(new Clear()));
        this.commonCommands.add(this.containerBuilder.create(new FindCommand()));
        this.commonCommands.add(this.containerBuilder.create(help));
        this.commonCommands.add(this.containerBuilder.create(new FeaturePackCommand()));
        this.commonCommands.add(this.containerBuilder.create(new ListFeaturePacksCommand()));
        this.commonCommands.add(this.containerBuilder.create(new MavenCommand()));
        this.commonCommands.add(this.containerBuilder.create(new PmExitCommand()));
        this.nominalCommands.add(this.containerBuilder.create(new CheckUpdatesCommand()));
        this.nominalCommands.add(this.containerBuilder.create(new FileSystemCommand()));
        this.nominalCommands.add(this.containerBuilder.create(new GetInfoCommand()));
        this.nominalCommands.add(this.containerBuilder.create(new InstallationCommand()));
        this.nominalCommands.add(new InstallCommand(pmSession).createCommand());
        this.nominalCommands.add(new ProvisionCommand(pmSession).createCommand());
        this.nominalCommands.add(this.containerBuilder.create(new StateCommand()));
        this.nominalCommands.add(this.containerBuilder.create(new UndoCommand()));
        this.nominalCommands.add(new UninstallCommand(pmSession).createCommand());
        this.nominalCommands.add(new UpdateCommand(pmSession).createCommand());
        this.editCommands.add(this.containerBuilder.create(new StateExportCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateGetInfoCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateLeaveCommand()));
        this.editCommands.add(new StateProvisionCommand(pmSession).createCommand());
        this.editCommands.add(this.containerBuilder.create(new StateSearchCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateUndoCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateAddFeaturePackCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateRemoveFeaturePackCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateExcludePackageCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateIncludePackageCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateRemoveExcludedPackageCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateRemoveIncludedPackageCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateRemoveFeatureCommand()));
        this.editCommands.add(new StateAddFeatureCommand(pmSession).createCommand());
        this.editCommands.add(this.containerBuilder.create(new StateExcludeConfigCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateIncludeConfigCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateResetConfigCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateRemoveExcludedConfigCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateRemoveIncludedConfigCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateCdCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateLsCommand()));
        this.editCommands.add(this.containerBuilder.create(new StatePwdCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateAddUniverseCommand()));
        this.editCommands.add(this.containerBuilder.create(new StateRemoveUniverseCommand()));
        this.setMode(Mode.NOMINAL);
    }

    public static ToolModes getModes(PmSession session, MutableCommandRegistry registry) throws CommandLineParserException {
        return new ToolModes(session, registry);
    }

    final void setMode(Mode mode) {
        Objects.requireNonNull(mode);
        this.activeMode = mode;
        this.clearCommands();
        this.registry.addAllCommandContainers(this.commonCommands);
        switch (mode) {
            case NOMINAL: {
                this.registry.addAllCommandContainers(this.nominalCommands);
                break;
            }
            case EDIT: {
                this.registry.addAllCommandContainers(this.editCommands);
            }
        }
    }

    public Mode getActiveMode() {
        return this.activeMode;
    }

    private void clearCommands() {
        HashSet<String> names = new HashSet<String>(this.registry.getAllCommandNames());
        for (String name : names) {
            this.registry.removeCommand(name);
        }
    }

    public static enum Mode {
        NOMINAL,
        EDIT;

    }
}

