/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CliLogging;
import org.jboss.galleon.cli.PmCompleterInvocation;
import org.jboss.galleon.cli.cmd.AbstractCommaSeparatedCompleter;
import org.jboss.galleon.cli.cmd.CommandWithInstallationDirectory;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.PathsUtils;

public class InstalledProducerCompleter
extends AbstractCommaSeparatedCompleter {
    @Override
    protected List<String> getItems(PmCompleterInvocation completerInvocation) {
        List<FeaturePackLocation> locations = InstalledProducerCompleter.getInstallationLocations(completerInvocation, true, false);
        ArrayList<String> items = new ArrayList<String>();
        for (FeaturePackLocation loc : locations) {
            items.add(loc.getProducer().toString());
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FeaturePackLocation> getInstallationLocations(PmCompleterInvocation completerInvocation, boolean transitive, boolean patches) {
        CommandWithInstallationDirectory cmd = (CommandWithInstallationDirectory)((Object)completerInvocation.getCommand());
        Path currentDir = cmd.getInstallationDirectory(completerInvocation.getAeshContext());
        ArrayList<FeaturePackLocation> items = new ArrayList<FeaturePackLocation>();
        try {
            PathsUtils.assertInstallationDir(currentDir);
            boolean trackersEnabled = completerInvocation.getPmSession().isTrackersEnabled();
            if (trackersEnabled) {
                completerInvocation.getPmSession().enableTrackers(false);
            }
            try {
                ProvisioningManager mgr = completerInvocation.getPmSession().newProvisioningManager(currentDir, false);
                try (ProvisioningLayout<FeaturePackLayout> layout = mgr.getLayoutFactory().newConfigLayout(mgr.getProvisioningConfig());){
                    for (FeaturePackLayout fp : layout.getOrderedFeaturePacks()) {
                        if (fp.isDirectDep() || fp.isTransitiveDep() && transitive) {
                            items.add(completerInvocation.getPmSession().getExposedLocation(cmd.getInstallationDirectory(completerInvocation.getAeshContext()), fp.getFPID().getLocation()));
                        }
                        if (!patches) continue;
                        List<FeaturePackLayout> appliedPatches = layout.getPatches(fp.getFPID());
                        for (FeaturePackLayout patch : appliedPatches) {
                            items.add(completerInvocation.getPmSession().getExposedLocation(cmd.getInstallationDirectory(completerInvocation.getAeshContext()), patch.getFPID().getLocation()));
                        }
                    }
                }
            }
            finally {
                completerInvocation.getPmSession().enableTrackers(trackersEnabled);
            }
        }
        catch (Exception ex) {
            CliLogging.completionException(ex);
        }
        return items;
    }
}

