/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.filesystem;

import java.io.File;
import java.util.List;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.io.FileResource;
import org.aesh.io.Resource;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;

@CommandDefinition(name="cd", description="Changes the current work dir")
public class CdCommand
extends PmSessionCommand {
    @Argument
    private File path;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        if (this.path == null) {
            return;
        }
        this.cdDir(session);
    }

    private void cdDir(PmCommandInvocation session) {
        FileResource res = new FileResource(this.path);
        AeshContext aeshCtx = session.getConfiguration().getAeshContext();
        List<Resource> files = res.resolve(aeshCtx.getCurrentWorkingDirectory());
        if (files.get(0).isDirectory()) {
            aeshCtx.setCurrentWorkingDirectory(files.get(0));
        }
        session.setPrompt(session.getPmSession().buildPrompt());
    }
}

