/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.ProvisioningManager;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.InstalledProducerCompleter;
import org.jboss.galleon.cli.cmd.Table;
import org.jboss.galleon.cli.cmd.maingrp.AbstractProvisioningCommand;
import org.jboss.galleon.cli.cmd.state.StateInfoUtil;
import org.jboss.galleon.layout.FeaturePackUpdatePlan;
import org.jboss.galleon.layout.ProvisioningPlan;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.PathsUtils;

@CommandDefinition(name="check-updates", description="Get available updates for a full installation or an identified feature pack")
public class CheckUpdatesCommand
extends AbstractProvisioningCommand {
    public static final String UP_TO_DATE = "Up to date. No available updates nor patches.";
    public static final String UPDATES_AVAILABLE = "Some updates and/or patches are available.";
    public static final String FP_OPTION_NAME = "feature-packs";
    private static final String NONE = "none";
    static final String ALL_DEPENDENCIES_OPTION_NAME = "include-all-dependencies";
    @Option(name="include-all-dependencies", hasValue=false, required=false, description="Include dependencies when checking for updates")
    boolean includeAll;
    @Option(name="feature-packs", hasValue=true, required=false, completer=InstalledProducerCompleter.class, description="The feature pack to search update for")
    String fp;

    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        try {
            ProvisioningManager mgr = this.getManager(session.getPmSession(), false);
            Updates updates = CheckUpdatesCommand.getUpdatesTable(mgr, session, this.includeAll, this.fp);
            if (updates.plan.isEmpty()) {
                session.println(UP_TO_DATE);
            } else {
                session.println(UPDATES_AVAILABLE);
                session.println(updates.t.build());
            }
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(session.getPmSession(), CliErrors.checkForUpdatesFailed(), ex);
        }
    }

    static Updates getUpdatesTable(ProvisioningManager mgr, PmCommandInvocation session, boolean includeAll, String fp) throws ProvisioningException, CommandExecutionException {
        ProvisioningPlan plan;
        if (!Files.exists(PathsUtils.getProvisioningXml(mgr.getInstallationHome()), new LinkOption[0])) {
            throw new CommandExecutionException(Errors.homeDirNotUsable(mgr.getInstallationHome()));
        }
        if (fp == null) {
            plan = mgr.getUpdates(includeAll);
        } else {
            String[] split = fp.split(",+");
            FeaturePackLocation.ProducerSpec[] resolved = new FeaturePackLocation.ProducerSpec[split.length];
            for (int i = 0; i < split.length; ++i) {
                resolved[i] = session.getPmSession().getResolvedLocation(mgr.getInstallationHome(), split[i]).getProducer();
            }
            plan = mgr.getUpdates(resolved);
        }
        Updates updates = new Updates();
        updates.plan = plan;
        if (plan.isEmpty()) {
            return updates;
        }
        ArrayList<String> headers = new ArrayList<String>();
        headers.add("Product");
        headers.add("Current Build");
        headers.add("Update");
        headers.add("Patches");
        if (includeAll) {
            headers.add("Dependency");
        }
        headers.add("Update Channel");
        updates.t = new Table(headers);
        for (FeaturePackUpdatePlan p : plan.getUpdates()) {
            FeaturePackLocation loc = p.getInstalledLocation();
            String update = p.hasNewLocation() ? p.getNewLocation().getBuild() : NONE;
            Table.Cell patches = new Table.Cell(new String[0]);
            if (p.hasNewPatches()) {
                for (FeaturePackLocation.FPID id : p.getNewPatches()) {
                    patches.addLine(id.getBuild());
                }
            } else {
                patches.addLine(NONE);
            }
            ArrayList<Table.Cell> line = new ArrayList<Table.Cell>();
            line.add(new Table.Cell(loc.getProducerName()));
            line.add(new Table.Cell(loc.getBuild()));
            line.add(new Table.Cell(update));
            line.add(patches);
            if (includeAll) {
                line.add(new Table.Cell(p.isTransitive() ? "Y" : "N"));
            }
            line.add(new Table.Cell(StateInfoUtil.formatChannel(loc)));
            updates.t.addCellsLine(line);
        }
        updates.t.sort(Table.SortType.ASCENDANT);
        return updates;
    }

    static class Updates {
        Table t;
        ProvisioningPlan plan;

        Updates() {
        }
    }
}

