/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.utils.Config;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.UniverseManager;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.universe.Producer;
import org.jboss.galleon.universe.UniverseSpec;

@CommandDefinition(name="find", description="Find feature pack locations that match the pattern")
public class FindCommand
extends PmSessionCommand {
    @Argument(description="Feature pack location pattern. eg: wildfly:*.Final to search for all Final builds")
    private String pattern;
    @Option(required=false, name="universe", description="Provide a universe id in order to search for feature packs located in not installed universe")
    private String fromUniverse;
    @Option(required=false, name="resolved-only", hasValue=false, description="Look-up in resolved feature-packs only")
    private Boolean resolvedOnly;

    @Override
    protected void runCommand(final PmCommandInvocation invoc) throws CommandExecutionException {
        if (this.pattern == null) {
            throw new CommandExecutionException(CliErrors.missingPattern());
        }
        final HashMap results = new HashMap();
        final HashMap<UniverseSpec, Exception> exceptions = new HashMap<UniverseSpec, Exception>();
        if (!this.pattern.endsWith("*")) {
            this.pattern = this.pattern + "*";
        }
        this.pattern = this.pattern.replaceAll("\\*", ".*");
        final boolean containsFrequency = this.pattern.contains("/");
        final Pattern compiledPattern = Pattern.compile(this.pattern);
        final Integer[] numResults = new Integer[]{0};
        try {
            final Comparator<FeaturePackLocation> locComparator = new Comparator<FeaturePackLocation>(){

                @Override
                public int compare(FeaturePackLocation o1, FeaturePackLocation o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            };
            UniverseManager.UniverseVisitor visitor = new UniverseManager.UniverseVisitor(){

                @Override
                public void visit(Producer<?> producer, FeaturePackLocation loc) {
                    try {
                        if (FindCommand.this.resolvedOnly.booleanValue() && !producer.getChannel(loc.getChannelName()).isResolved(loc)) {
                            return;
                        }
                    }
                    catch (ProvisioningException ex) {
                        this.exception(loc.getUniverse(), ex);
                        return;
                    }
                    FeaturePackLocation exposedLoc = invoc.getPmSession().getExposedLocation(null, loc);
                    boolean canonicalMatch = compiledPattern.matcher(loc.toString()).matches();
                    boolean exposedMatch = compiledPattern.matcher(exposedLoc.toString()).matches();
                    if ((canonicalMatch || exposedMatch) && (containsFrequency && loc.getFrequency() != null || !containsFrequency && loc.getFrequency() == null)) {
                        TreeSet<FeaturePackLocation> locations = (TreeSet<FeaturePackLocation>)results.get(loc.getUniverse());
                        if (locations == null) {
                            locations = new TreeSet<FeaturePackLocation>(locComparator);
                            results.put(loc.getUniverse(), locations);
                        }
                        if (exposedMatch) {
                            locations.add(exposedLoc);
                        } else {
                            locations.add(loc);
                        }
                        numResults[0] = numResults[0] + 1;
                    }
                }

                @Override
                public void exception(UniverseSpec spec, Exception ex) {
                    exceptions.put(spec, ex);
                }
            };
            if (this.fromUniverse == null) {
                invoc.getPmSession().getUniverse().visitAllUniverses(visitor, true);
            } else {
                invoc.getPmSession().getUniverse().visitUniverse(UniverseSpec.fromString(this.fromUniverse), visitor, true);
            }
            invoc.println(Config.getLineSeparator() + "Found " + numResults[0] + " feature pack locations.");
            FindCommand.printExceptions(invoc, exceptions);
            for (Map.Entry entry : results.entrySet()) {
                UniverseSpec universeSpec = (UniverseSpec)entry.getKey();
                String universeName = invoc.getPmSession().getUniverse().getUniverseName(null, universeSpec);
                universeName = universeName == null ? universeSpec.toString() : universeName;
                invoc.println(Config.getLineSeparator() + "Universe " + universeName + Config.getLineSeparator());
                for (FeaturePackLocation loc : (Set)entry.getValue()) {
                    invoc.println(loc.toString());
                }
            }
        }
        catch (ProvisioningException ex) {
            throw new CommandExecutionException(ex.getLocalizedMessage());
        }
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.PROVISIONING;
    }

    public static void printExceptions(PmCommandInvocation invoc, Map<UniverseSpec, Exception> exceptions) {
        if (!exceptions.isEmpty()) {
            invoc.println("Some exceptions occured while accessing universes:");
        }
        for (Map.Entry<UniverseSpec, Exception> entry : exceptions.entrySet()) {
            invoc.println(Config.getLineSeparator() + "Exception for " + exceptions.get(entry.getKey()).getMessage() + Config.getLineSeparator());
        }
    }
}

