/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.maingrp;

import java.io.IOException;
import java.util.function.Function;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Option;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.maingrp.AbstractProvisioningCommand;
import org.jboss.galleon.cli.cmd.state.InfoTypeCompleter;
import org.jboss.galleon.cli.cmd.state.StateInfoUtil;
import org.jboss.galleon.cli.model.FeatureContainer;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;

@CommandDefinition(name="get-info", description="Display information on an installation directory")
public class GetInfoCommand
extends AbstractProvisioningCommand {
    @Option(completer=InfoTypeCompleter.class, description="Type of information to display (all, configs, dependencies, options, patches)")
    private String type;

    @Override
    protected void runCommand(final PmCommandInvocation invoc) throws CommandExecutionException {
        try {
            ProvisioningConfig config = this.getProvisioningConfig(invoc.getPmSession());
            Function<ProvisioningLayout<FeaturePackLayout>, FeatureContainer> supplier = new Function<ProvisioningLayout<FeaturePackLayout>, FeatureContainer>(){

                @Override
                public FeatureContainer apply(ProvisioningLayout<FeaturePackLayout> layout) {
                    try {
                        return GetInfoCommand.this.getFeatureContainer(invoc.getPmSession(), layout);
                    }
                    catch (IOException | ProvisioningException | CommandExecutionException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
            StateInfoUtil.displayInfo(invoc, this.getInstallationDirectory(invoc.getConfiguration().getAeshContext()), config, this.type, supplier);
        }
        catch (ProvisioningException | CommandExecutionException ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.infoFailed(), ex);
        }
    }
}

