/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.plugin;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.aesh.command.impl.completer.FileOptionCompleter;
import org.aesh.command.impl.internal.OptionType;
import org.aesh.command.impl.internal.ProcessedOption;
import org.aesh.command.impl.internal.ProcessedOptionBuilder;
import org.aesh.command.parser.OptionParserException;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandActivator;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.plugin.AbstractPluginsCommand;
import org.jboss.galleon.cli.resolver.PluginResolver;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.PathsUtils;

@Deprecated
public class DiffCommand
extends AbstractPluginsCommand {
    private static final String SRC_NAME = "src";
    private static final String TARGET_NAME = "target";

    public DiffCommand(PmSession pmSession) {
        super(pmSession);
    }

    @Override
    protected void runCommand(PmCommandInvocation session, Map<String, String> options, FeaturePackLocation loc) throws CommandExecutionException {
    }

    @Override
    protected Set<PluginOption> getPluginOptions(FeaturePackLocation loc) throws ProvisioningException {
        try {
            return this.pmSession.getResolver().get(loc.toString(), PluginResolver.newResolver(this.pmSession, loc)).getDiff();
        }
        catch (InterruptedException ex) {
            Thread.interrupted();
            throw new ProvisioningException(ex);
        }
        catch (ExecutionException ex) {
            throw new ProvisioningException(ex.getCause());
        }
    }

    @Override
    protected List<ProcessedOption> getOtherOptions() throws OptionParserException {
        ArrayList<ProcessedOption> options = new ArrayList<ProcessedOption>();
        ProcessedOption srcDir = ProcessedOptionBuilder.builder().name(SRC_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("Customized source installation directory").completer(FileOptionCompleter.class).build();
        options.add(srcDir);
        ProcessedOption targetDir = ProcessedOptionBuilder.builder().name(TARGET_NAME).hasValue(true).type(String.class).optionType(OptionType.NORMAL).description("Directory to save the feature pack to").completer(FileOptionCompleter.class).build();
        options.add(targetDir);
        return options;
    }

    @Override
    protected void doValidateOptions(PmCommandInvocation invoc) throws CommandExecutionException {
    }

    @Override
    protected String getName() {
        return "diff";
    }

    @Override
    protected String getDescription() {
        return "Save the current provisioned configuration changes into a feature pack";
    }

    @Override
    public Path getInstallationDirectory(AeshContext context) {
        String srcPath = (String)this.getValue(SRC_NAME);
        return srcPath == null ? PmSession.getWorkDir(context) : this.toPath(srcPath, context);
    }

    private Path toPath(String value, AeshContext context) {
        Path workDir = PmSession.getWorkDir(context);
        return value == null ? PmSession.getWorkDir(context) : workDir.resolve(value);
    }

    @Override
    protected PmCommandActivator getActivator() {
        return null;
    }

    @Override
    protected boolean canComplete(PmSession pmSession) {
        Path installation = this.getPathOption(SRC_NAME);
        String target = null;
        if (Files.exists(PathsUtils.getProvisioningXml(installation), new LinkOption[0]) && (target = (String)this.getValue(TARGET_NAME)) == null) {
            target = this.getOptionValue(TARGET_NAME);
        }
        return target != null;
    }

    private Path getPathOption(String name) {
        String path = (String)this.getValue(name);
        if (path == null) {
            path = this.getOptionValue(name);
        }
        Path workDir = PmSession.getWorkDir(this.pmSession.getAeshContext());
        return path == null ? workDir : workDir.resolve(path);
    }

    @Override
    public CommandDomain getDomain() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

