/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.resolver;

import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.resolver.ResolutionException;
import org.jboss.galleon.cli.resolver.ResolvedPlugins;
import org.jboss.galleon.cli.resolver.ResourceResolver;
import org.jboss.galleon.config.ProvisioningConfig;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.FeaturePackPluginVisitor;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.plugin.DiffPlugin;
import org.jboss.galleon.plugin.InstallPlugin;
import org.jboss.galleon.plugin.PluginOption;
import org.jboss.galleon.universe.FeaturePackLocation;

public class PluginResolver
implements ResourceResolver.Resolver<ResolvedPlugins> {
    private ProvisioningConfig config;
    private Path file;
    private final PmSession session;
    private ProvisioningLayout<FeaturePackLayout> layout;

    private PluginResolver(PmSession session, ProvisioningConfig config) {
        Objects.requireNonNull(session);
        Objects.requireNonNull(config);
        this.session = session;
        this.config = config;
    }

    private PluginResolver(PmSession session, Path file) {
        Objects.requireNonNull(session);
        Objects.requireNonNull(file);
        this.session = session;
        this.file = file;
    }

    private PluginResolver(PmSession session, ProvisioningLayout<FeaturePackLayout> layout) {
        Objects.requireNonNull(session);
        Objects.requireNonNull(layout);
        this.session = session;
        this.layout = layout;
    }

    public static PluginResolver newResolver(PmSession session, ProvisioningLayout<FeaturePackLayout> layout) {
        return new PluginResolver(session, layout);
    }

    public static PluginResolver newResolver(PmSession session, ProvisioningConfig config) {
        return new PluginResolver(session, config);
    }

    public static PluginResolver newResolver(PmSession session, Path file) {
        return new PluginResolver(session, file);
    }

    public static PluginResolver newResolver(PmSession session, FeaturePackLocation loc) throws ProvisioningDescriptionException {
        ProvisioningConfig config = ((ProvisioningConfig.Builder)ProvisioningConfig.builder().addFeaturePackDep(loc)).build();
        return new PluginResolver(session, config);
    }

    /*
     * Loose catch block
     */
    @Override
    public ResolvedPlugins resolve() throws ResolutionException {
        boolean closeLayout = this.layout == null;
        ProvisioningLayout<FeaturePackLayout> pLayout = this.layout;
        this.session.unregisterTrackers();
        try {
            try {
                if (pLayout == null) {
                    pLayout = this.config != null ? this.session.getLayoutFactory().newConfigLayout(this.config) : this.session.getLayoutFactory().newConfigLayout(this.file, false);
                }
                ResolvedPlugins resolvedPlugins = PluginResolver.resolvePlugins(pLayout);
                return resolvedPlugins;
            }
            catch (Exception ex) {
                throw new ResolutionException(ex.getLocalizedMessage(), ex);
            }
            finally {
                if (closeLayout && pLayout != null) {
                    pLayout.close();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.session.registerTrackers();
        }
    }

    public static ResolvedPlugins resolvePlugins(ProvisioningLayout<FeaturePackLayout> layout) throws ProvisioningException {
        ResolvedPlugins plugins = null;
        if (layout.hasPlugins()) {
            final HashSet<PluginOption> installOptions = new HashSet<PluginOption>();
            FeaturePackPluginVisitor<InstallPlugin> visitor = new FeaturePackPluginVisitor<InstallPlugin>(){

                @Override
                public void visitPlugin(InstallPlugin plugin) throws ProvisioningException {
                    installOptions.addAll(plugin.getOptions().values());
                }
            };
            layout.visitPlugins(visitor, InstallPlugin.class);
            final HashSet<PluginOption> diffOptions = new HashSet<PluginOption>();
            FeaturePackPluginVisitor<DiffPlugin> diffVisitor = new FeaturePackPluginVisitor<DiffPlugin>(){

                @Override
                public void visitPlugin(DiffPlugin plugin) throws ProvisioningException {
                    diffOptions.addAll(plugin.getOptions().values());
                }
            };
            layout.visitPlugins(diffVisitor, DiffPlugin.class);
            plugins = new ResolvedPlugins(installOptions, diffOptions);
        }
        return plugins == null ? new ResolvedPlugins(Collections.emptySet(), Collections.emptySet()) : plugins;
    }
}

