/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.config;

import java.util.Collections;
import java.util.Map;
import org.jboss.galleon.ProvisioningDescriptionException;
import org.jboss.galleon.config.FeaturePackConfig;
import org.jboss.galleon.config.FeaturePackDepsConfig;
import org.jboss.galleon.config.FeaturePackDepsConfigBuilder;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.StringUtils;

public class ProvisioningConfig
extends FeaturePackDepsConfig {
    private final Map<String, String> pluginOptions;
    private final Builder builder;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ProvisioningConfig provisioningConfig) throws ProvisioningDescriptionException {
        return new Builder(provisioningConfig);
    }

    private ProvisioningConfig(Builder builder) throws ProvisioningDescriptionException {
        super(builder);
        this.pluginOptions = CollectionUtils.unmodifiable(builder.pluginOptions);
        this.builder = builder;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public boolean hasPluginOptions() {
        return !this.pluginOptions.isEmpty();
    }

    public Map<String, String> getPluginOptions() {
        return this.pluginOptions;
    }

    public boolean hasPluginOption(String name) {
        return this.pluginOptions.containsKey(name);
    }

    public String getPluginOption(String name) {
        return this.pluginOptions.get(name);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.pluginOptions == null ? 0 : this.pluginOptions.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProvisioningConfig other = (ProvisioningConfig)obj;
        return !(this.pluginOptions == null ? other.pluginOptions != null : !this.pluginOptions.equals(other.pluginOptions));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append('[');
        if (this.defaultUniverse != null) {
            buf.append("default-universe=").append(this.defaultUniverse);
        }
        if (!this.universeSpecs.isEmpty()) {
            if (this.defaultUniverse != null) {
                buf.append(' ');
            }
            buf.append("universes=[");
            StringUtils.append(buf, this.universeSpecs.entrySet());
            buf.append("] ");
        }
        if (!this.pluginOptions.isEmpty()) {
            buf.append("plugin-options=");
            StringUtils.append(buf, this.pluginOptions.entrySet());
        }
        if (!this.transitiveDeps.isEmpty()) {
            buf.append("transitive=");
            StringUtils.append(buf, this.transitiveDeps.values());
            buf.append(' ');
        }
        StringUtils.append(buf, this.fpDeps.values());
        this.append(buf);
        return buf.append(']').toString();
    }

    public static class Builder
    extends FeaturePackDepsConfigBuilder<Builder> {
        private Map<String, String> pluginOptions = Collections.emptyMap();

        private Builder() {
        }

        private Builder(ProvisioningConfig original) throws ProvisioningDescriptionException {
            if (original == null) {
                return;
            }
            if (original.hasPluginOptions()) {
                this.addPluginOptions(original.getPluginOptions());
            }
            for (FeaturePackConfig fp : original.getFeaturePackDeps()) {
                this.addFeaturePackDep(original.originOf(fp.getLocation().getProducer()), fp);
            }
            if (original.hasTransitiveDeps()) {
                for (FeaturePackConfig fp : original.getTransitiveDeps()) {
                    this.addFeaturePackDep(original.originOf(fp.getLocation().getProducer()), fp);
                }
            }
            this.initUniverses(original);
            this.initConfigs(original);
        }

        public Builder addPluginOption(String name, String value) {
            this.pluginOptions = CollectionUtils.put(this.pluginOptions, name, value);
            return this;
        }

        public Builder removePluginOption(String name) {
            this.pluginOptions = CollectionUtils.remove(this.pluginOptions, name);
            return this;
        }

        public Builder addPluginOptions(Map<String, String> options) {
            this.pluginOptions = CollectionUtils.putAll(this.pluginOptions, options);
            return this;
        }

        public ProvisioningConfig build() throws ProvisioningDescriptionException {
            return new ProvisioningConfig(this);
        }
    }
}

