/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.diff;

import difflib.DiffUtils;
import difflib.Patch;
import java.io.IOException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.ProviderException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.galleon.MessageWriter;
import org.jboss.galleon.diff.ProvisioningDiffResult;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.PathFilter;

public class FileSystemDiff {
    private final Path stagedInstallation;
    private final Path customizedInstallation;
    protected final MessageWriter messageWriter;

    public FileSystemDiff(MessageWriter messageWriter, Path stagedInstallation, Path customizedInstallation) {
        this.stagedInstallation = stagedInstallation;
        this.customizedInstallation = customizedInstallation;
        this.messageWriter = messageWriter;
    }

    public ProvisioningDiffResult diff() throws ProviderException {
        return this.diff(PathFilter.DEFAULT);
    }

    public ProvisioningDiffResult diff(PathFilter filter) throws ProviderException {
        try {
            Map<Path, String> stagged = IoUtils.listContents(this.stagedInstallation, filter);
            Map<Path, String> custom = IoUtils.listContents(this.customizedInstallation, filter);
            Changes changes = this.listChanges(stagged, custom);
            return new ProvisioningDiffResult(this.listDeletedFiles(stagged, custom), this.listAddedFiles(stagged, custom), changes.modifiedBinaryFiles, changes.unifiedDiff);
        }
        catch (IOException ioex) {
            throw new ProviderException(ioex);
        }
    }

    private Set<Path> listDeletedFiles(Map<Path, String> stagged, Map<Path, String> custom) {
        HashSet<Path> deletedFiles = new HashSet<Path>();
        for (Path path : stagged.keySet()) {
            Path staggedPath;
            if (custom.containsKey(path) || !Files.exists(staggedPath = this.resolveStagePath(path), new LinkOption[0]) || Files.isDirectory(staggedPath, new LinkOption[0]) && Files.exists(this.resolveOriginPath(path), new LinkOption[0])) continue;
            deletedFiles.add(path);
        }
        return deletedFiles;
    }

    private Set<Path> listAddedFiles(Map<Path, String> stagged, Map<Path, String> custom) {
        HashSet<Path> addedFiles = new HashSet<Path>();
        for (Path path : custom.keySet()) {
            if (stagged.containsKey(path)) continue;
            addedFiles.add(path);
        }
        return addedFiles;
    }

    private Path resolveStagePath(Path path) {
        return this.stagedInstallation.resolve(path);
    }

    private Path resolveOriginPath(Path path) {
        return this.customizedInstallation.resolve(path);
    }

    private Changes listChanges(Map<Path, String> stagged, Map<Path, String> custom) throws IOException {
        Changes changes = new Changes();
        for (Map.Entry<Path, String> entry : stagged.entrySet()) {
            Path path = entry.getKey();
            if (!custom.containsKey(path) || custom.get(path).equals(entry.getValue())) continue;
            try {
                changes.unifiedDiff.put(path, this.extractUnifiedDiff(this.resolveStagePath(path), this.resolveOriginPath(path)));
            }
            catch (MalformedInputException ex) {
                changes.modifiedBinaryFiles.add(path);
            }
        }
        return changes;
    }

    private List<String> extractUnifiedDiff(Path revised, Path original) throws IOException {
        List<String> revisedLines = Files.readAllLines(revised, StandardCharsets.UTF_8);
        List<String> originalLines = Files.readAllLines(original, StandardCharsets.UTF_8);
        Patch<String> patch = DiffUtils.diff(originalLines, revisedLines);
        return DiffUtils.generateUnifiedDiff(revised.toString(), original.toString(), revisedLines, patch, 0);
    }

    private static class Changes {
        private final Map<Path, List<String>> unifiedDiff = new HashMap<Path, List<String>>();
        private final Set<Path> modifiedBinaryFiles = new HashSet<Path>();

        private Changes() {
        }
    }
}

